/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 1996 Microsoft Corporation. All rights reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corp.
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 */
Cufon.registerFont({"w":188,"face":{"font-family":"Trebuchet MS","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 3 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-31 -339 390 95","underline-thickness":"22.3242","underline-position":"-34.8047","unicode-range":"U+0020-U+F007"},"glyphs":{" ":{"w":108,"k":{"Y":7,"T":7,"A":20}},"!":{"d":"73,-67r-13,0v-15,-96,-13,-114,-13,-195r39,0v0,81,2,98,-13,195xm41,-23v0,-14,12,-26,27,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27","w":132},"\"":{"d":"40,-191r-23,0r-4,-67r32,0xm98,-191r-23,0r-4,-67r32,0","w":116},"#":{"d":"155,-166r-18,69r28,0r0,22r-34,0r-21,79r-23,0r22,-79r-52,0r-22,79r-23,0r22,-79r-27,0r0,-22r33,0r17,-69r-30,0r0,-23r36,0r18,-72r23,0r-18,72r52,0r18,-72r22,0r-18,72r31,0r0,23r-36,0xm80,-166r-17,69r52,0r17,-69r-52,0"},"$":{"d":"156,-110v27,46,4,111,-51,113r0,40r-24,0r0,-39v-14,1,-47,-11,-56,-16r12,-32v32,31,120,15,93,-42v-21,-43,-106,-36,-106,-109v0,-35,25,-61,57,-66r0,-28r24,0r0,27v25,1,42,6,51,14r-10,31v-24,-18,-89,-25,-87,21v3,53,76,51,97,86"},"%":{"d":"38,4r-22,0r155,-266r22,0xm109,-201v0,33,-18,60,-49,60v-33,0,-49,-21,-49,-63v0,-32,19,-59,50,-58v31,0,48,26,48,61xm61,-244v-20,0,-28,20,-28,42v0,22,7,43,25,43v19,0,28,-14,28,-43v0,-28,-8,-42,-25,-42xm204,-56v0,33,-19,59,-49,60v-33,0,-49,-21,-49,-63v0,-32,19,-59,50,-58v31,0,48,26,48,61xm156,-99v-20,0,-29,19,-28,41v0,23,7,44,25,44v19,0,28,-14,28,-43v0,-28,-8,-42,-25,-42","w":216},"&":{"d":"181,-126v0,48,-9,125,51,93r5,31v-24,7,-56,11,-74,-7v-59,30,-145,8,-138,-71v3,-33,9,-46,28,-66v-52,-42,-16,-116,50,-116v24,0,43,5,56,16r-15,27v-27,-30,-85,-19,-82,25v0,15,6,28,20,39r66,0r0,-32r33,-13r0,46r44,0r0,28r-44,0xm150,-35v-4,-26,-1,-62,-2,-91r-71,0v-31,35,-20,100,37,100v16,0,28,-3,36,-9","w":254},"'":{"d":"40,-191r-23,0r-4,-67r32,0","w":57},"(":{"d":"109,75v-68,-45,-99,-176,-53,-270v16,-33,33,-54,53,-64r0,14v-48,55,-45,256,0,302r0,18","w":132},")":{"d":"34,-259v65,36,97,176,55,263v-15,30,-31,54,-55,71r0,-18v45,-46,48,-247,0,-302r0,-14","w":132},"*":{"d":"120,-203v-11,6,-28,5,-45,5v13,9,27,17,36,30r-22,18v-10,-12,-16,-26,-24,-40r-23,40r-23,-18v6,-15,23,-19,36,-27v-16,-3,-33,-5,-47,-10r13,-27v16,5,27,15,39,24v-4,-17,-12,-29,-11,-50r31,0v1,21,-7,33,-11,50v13,-8,24,-19,41,-24","w":132},"+":{"d":"107,-124r62,0r0,25r-62,0r0,60r-24,0r0,-60r-62,0r0,-25r62,0r0,-60r24,0r0,60"},",":{"d":"66,-49v30,2,30,49,15,71v-7,12,-21,26,-42,42r-9,-13v20,-17,31,-30,31,-42v0,-16,-23,-22,-21,-36v-1,-13,12,-23,26,-22","w":132},"-":{"d":"28,-89r0,-31r75,0r0,31r-75,0","w":132},"\u2010":{"d":"28,-89r0,-31r75,0r0,31r-75,0","w":132},".":{"d":"36,-23v0,-14,12,-26,26,-26v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27","w":132},"\/":{"d":"62,0r-29,0r94,-259r28,0"},"0":{"d":"95,4v-72,0,-83,-49,-84,-141v0,-66,27,-125,86,-125v67,0,81,48,81,131v0,72,-20,135,-83,135xm143,-133v0,-56,-1,-99,-47,-99v-33,0,-50,33,-50,99v0,71,16,107,46,107v47,0,51,-44,51,-107"},"1":{"d":"35,-198v25,-12,62,-40,77,-61r11,0r0,259r-35,0r0,-197r-53,32r0,-33"},"2":{"d":"76,-262v85,0,93,73,51,139r-58,91r101,0r0,32r-158,0r0,-7v32,-58,96,-118,106,-190v7,-48,-75,-41,-85,-9r-23,-18v8,-22,34,-38,66,-38"},"3":{"d":"165,-71v0,76,-98,95,-146,53r17,-27v25,32,97,24,92,-29v-3,-31,-21,-50,-54,-49v1,-9,-2,-22,1,-29v30,0,45,-13,45,-39v0,-45,-56,-52,-79,-26r-15,-24v34,-41,131,-19,131,43v0,28,-19,53,-40,60v27,8,48,33,48,67"},"4":{"d":"155,-70r0,70r-33,0r0,-70r-118,0r0,-20r139,-169r12,0r0,162r26,0r0,27r-26,0xm122,-188r-76,91r76,0r0,-91"},"5":{"d":"62,-166v51,-29,114,10,107,73v10,93,-88,120,-146,76r13,-29v39,36,96,24,96,-42v0,-61,-59,-74,-91,-38r-12,-8r0,-125r128,0r0,30r-95,0r0,63"},"6":{"d":"174,-79v0,47,-31,81,-75,83v-94,5,-104,-141,-51,-208v24,-31,45,-52,70,-58r17,19v-17,4,-78,75,-77,96v48,-37,116,4,116,68xm138,-78v1,-28,-16,-54,-42,-53v-30,0,-44,16,-44,50v0,37,15,56,45,56v27,0,41,-24,41,-53"},"7":{"d":"75,0r-39,0v18,-59,72,-171,100,-225r-121,0r0,-34r167,0v1,28,-14,39,-23,59r-69,157v-6,16,-11,30,-15,43"},"8":{"d":"94,4v-96,0,-97,-124,-32,-147v-19,-10,-37,-31,-37,-57v-1,-39,30,-62,70,-62v78,0,87,97,33,122v75,32,54,144,-34,144xm129,-201v0,-19,-14,-32,-34,-31v-23,0,-35,11,-35,32v0,16,15,31,45,46v16,-15,24,-31,24,-47xm94,-26v36,0,58,-43,36,-72v-6,-8,-20,-19,-41,-30v-26,14,-38,33,-38,57v0,25,18,45,43,45"},"9":{"d":"13,-178v0,-47,30,-82,74,-84v94,-5,105,140,52,208v-25,31,-45,52,-70,58r-17,-18v16,-5,77,-76,77,-96v-49,35,-116,-4,-116,-68xm49,-180v-1,29,16,54,42,54v30,0,44,-17,44,-51v0,-37,-15,-55,-45,-55v-28,-1,-41,24,-41,52"},":":{"d":"36,-165v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26xm36,-23v0,-14,12,-26,26,-26v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27","w":132},";":{"d":"36,-165v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26xm66,-49v30,2,30,49,15,71v-7,12,-21,26,-42,42r-9,-13v20,-17,31,-30,31,-42v0,-16,-23,-22,-21,-36v-1,-13,12,-23,26,-22","w":132},"<":{"d":"156,-38r-130,-63r0,-22r130,-62r0,28r-100,45r100,45r0,29"},"=":{"d":"169,-154r0,25r-148,0r0,-25r148,0xm169,-94r0,25r-148,0r0,-25r148,0"},">":{"d":"156,-101r-130,63r0,-29r101,-45r-101,-45r0,-28r130,62r0,22"},"?":{"d":"7,-248v44,-34,139,-5,110,65v-15,36,-67,53,-53,108r-23,0v-27,-59,42,-84,48,-129v4,-34,-50,-40,-69,-18xm31,-23v0,-14,11,-26,26,-26v14,0,26,11,26,26v0,15,-12,27,-26,27v-14,0,-26,-12,-26,-27","w":132},"@":{"d":"43,-102v0,88,102,134,164,82v5,2,13,5,23,10v-22,22,-51,34,-88,34v-74,1,-124,-51,-124,-126v0,-75,51,-131,124,-131v70,0,119,48,118,117v0,37,-21,72,-58,71v-19,0,-32,-4,-40,-12v-23,25,-79,16,-77,-24v1,-33,33,-46,70,-46v0,-31,-34,-29,-50,-16r-8,-17v35,-24,90,-8,84,45r0,42v29,23,54,4,54,-44v0,-52,-41,-94,-93,-94v-61,0,-99,48,-99,109xm155,-110v-43,-11,-60,47,-20,50v7,0,14,-3,20,-9r0,-41","w":277},"A":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0","w":212,"k":{"\u2019":40,"y":15,"w":17,"v":20,"Y":38,"W":32,"V":32,"T":35," ":20}},"B":{"d":"190,-74v0,75,-83,78,-164,74r0,-258v81,-6,143,-7,148,62v2,24,-23,47,-43,51v38,10,58,27,59,71xm62,-229r0,74v37,5,82,-3,77,-40v5,-35,-43,-40,-77,-34xm153,-80v0,-47,-42,-52,-91,-48r0,98v50,6,91,-1,91,-50","w":203},"C":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132","w":215},"D":{"d":"26,-258v117,-14,177,23,181,119v4,114,-65,149,-181,139r0,-258xm62,-33v73,11,108,-32,108,-103v0,-71,-38,-101,-108,-90r0,193","w":220},"E":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0","w":192},"F":{"d":"62,-226r0,72r90,0r0,30r-90,0r0,124r-36,0r0,-258r159,0r0,32r-123,0","k":{"A":38,".":65,",":65}},"G":{"d":"14,-128v0,-104,109,-172,191,-112r-15,29v-65,-50,-139,4,-139,85v0,76,74,127,131,82r0,-60r-36,0r0,-30r71,0r0,112v-16,15,-57,26,-88,26v-73,1,-115,-56,-115,-132","w":243},"H":{"d":"174,0r0,-124r-112,0r0,124r-36,0r0,-258r36,0r0,104r112,0r0,-104r35,0r0,258r-35,0","w":235},"I":{"d":"33,0r0,-258r35,0r0,258r-35,0","w":100},"J":{"d":"145,-258v-10,103,38,262,-77,262v-34,0,-58,-22,-59,-56r30,0v3,16,12,24,28,24v43,-2,43,-15,43,-67r0,-163r35,0","w":171},"K":{"d":"168,0r-72,-118r-34,48r0,70r-36,0r0,-258r36,0r0,141r95,-141r39,0r-77,112r88,146r-39,0","w":207,"k":{"w":11,"u":11,"o":11,"n":11,"i":11,"e":11}},"L":{"d":"26,0r0,-258r36,0r0,226r116,0r0,32r-152,0","w":182,"k":{"\u2019":36,"y":30,"Y":47,"W":45,"V":50,"T":37," ":13}},"M":{"d":"220,0r-30,-165r-57,169r-8,0r-58,-169r-30,165r-33,0r48,-258r16,0r61,188r57,-188r15,0r53,258r-34,0","w":255},"N":{"d":"193,4r-133,-189r0,185r-34,0r0,-258r14,0r130,179r0,-179r33,0r0,262r-10,0","w":229},"O":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99","w":242},"P":{"d":"62,-99r0,99r-36,0r0,-258v92,-7,161,8,161,74v0,67,-50,95,-125,85xm62,-226r0,95v54,8,88,-8,88,-50v0,-37,-41,-53,-88,-45","w":200,"k":{"r":17,"o":17,"i":17,"h":17,"e":17,"a":17,"A":40,".":70,",":70," ":7}},"Q":{"d":"118,-262v75,0,111,54,111,131v0,59,-19,100,-54,122v16,25,50,30,92,28r-5,34v-61,0,-102,-17,-121,-51v-82,15,-127,-53,-127,-133v0,-69,38,-132,104,-131xm118,-27v52,0,75,-46,74,-104v0,-66,-25,-99,-74,-99v-50,0,-66,45,-67,99v-1,53,20,104,67,104","w":243},"R":{"d":"185,-186v0,31,-24,62,-50,68r75,118r-41,0r-68,-111v-8,0,-21,0,-38,-1r0,112r-35,0r0,-258v76,-7,157,-1,157,72xm148,-187v0,-40,-42,-44,-85,-39r0,84v43,5,85,1,85,-45","w":209,"k":{"u":10,"o":15,"e":15,"Y":23,"W":23,"V":17,"T":15}},"S":{"d":"111,-139v78,32,52,143,-38,143v-23,0,-42,-5,-58,-16r13,-32v27,24,96,25,96,-23v0,-53,-79,-52,-99,-88v-27,-49,5,-107,62,-107v28,0,48,5,59,14r-10,31v-24,-19,-89,-24,-87,21v1,38,32,45,62,57","w":173},"T":{"d":"120,-226r0,226r-35,0r0,-226r-82,0r0,-32r203,0r0,32r-86,0","w":209,"k":{"y":41,"w":50,"u":47,"s":43,"r":40,"o":45,"i":15,"e":45,"c":45,"a":45,"O":20,"A":35,";":40,":":40,".":60,"-":35,",":60," ":7}},"U":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82","w":233},"V":{"d":"116,4r-18,0r-96,-262r39,0r67,190r63,-190r38,0","w":211,"k":{"y":13,"u":23,"r":22,"o":23,"i":7,"e":23,"a":28,"A":37,";":22,":":22,".":53,"-":27,",":53}},"W":{"d":"224,4r-11,0r-61,-178r-57,178r-12,0r-81,-262r37,0r52,180r56,-180r12,0r56,180r53,-180r36,0","w":306,"k":{"y":7,"u":15,"r":18,"o":17,"i":5,"e":17,"a":20,"A":32,";":7,":":7,".":33,"-":25,",":33}},"X":{"d":"161,0r-64,-103r-59,103r-36,0r76,-134r-70,-124r35,0r55,98r61,-98r35,0r-80,125r84,133r-37,0","w":200},"Y":{"d":"120,-115r0,115r-35,0r0,-115r-83,-143r36,0r65,113r64,-113r36,0","w":205,"k":{"v":21,"u":27,"q":43,"p":33,"o":41,"i":20,"e":38,"a":33,"A":38,";":31,":":31,".":58,"-":44,",":58," ":7}},"Z":{"d":"18,0r0,-9r110,-217r-109,0r0,-32r158,0r0,9r-111,217r115,0r0,32r-163,0","w":198},"[":{"d":"36,74r0,-339r81,0r0,29r-46,0r0,280r46,0r0,30r-81,0","w":132},"\\":{"d":"90,0r-91,-259r25,0r91,259r-25,0","w":127},"]":{"d":"97,74r-82,0r0,-30r47,0r0,-280r-47,0r0,-29r82,0r0,339","w":132},"^":{"d":"134,-159r-43,-79r-43,79r-22,0r56,-100r19,0r55,100r-22,0"},"_":{"d":"-1,45r0,-23r190,0r0,23r-190,0"},"`":{"d":"98,-226r-39,-58r34,0r30,58r-25,0"},"a":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45","w":189},"b":{"d":"187,-98v9,79,-78,131,-135,84v-6,9,-9,22,-28,18r0,-269r33,0r0,91v49,-46,138,5,130,76xm152,-96v3,-55,-58,-88,-95,-53r0,109v0,4,27,16,32,15v48,0,60,-22,63,-71","w":200},"c":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78","w":178},"d":{"d":"13,-89v-6,-69,71,-132,130,-89r0,-87r33,0r0,265r-33,0r0,-14v-52,43,-140,-1,-130,-75xm48,-93v-7,60,58,86,95,53r0,-105v-32,-45,-102,-2,-95,52","w":200},"e":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0","w":196},"f":{"d":"39,-188v-3,-56,41,-91,96,-72r-9,24v-33,-12,-61,12,-54,48r39,0r0,28r-39,0r0,160r-33,0r0,-160r-28,0r0,-28r28,0","w":133,"k":{"\u2019":8}},"g":{"d":"170,16v0,66,-110,71,-153,36r18,-27v19,13,38,19,54,19v24,0,49,-7,49,-27v0,-52,-120,14,-117,-47v0,-15,18,-25,33,-28v-66,-24,-43,-134,31,-134v19,0,34,4,44,12r17,-20r21,20r-20,15v33,44,-1,116,-51,114v-18,3,-45,0,-49,15v6,16,48,2,64,2v36,0,59,16,59,50xm126,-123v0,-23,-16,-42,-38,-42v-24,-1,-40,19,-40,42v0,25,15,47,40,46v24,-1,38,-20,38,-46","w":180},"h":{"d":"109,-192v84,-1,61,111,64,192r-33,0v-7,-61,24,-161,-40,-164v-17,-1,-36,14,-43,24r0,140r-33,0r0,-265r33,0r0,97v8,-12,31,-24,52,-24","w":196},"i":{"d":"38,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21xm40,0r0,-160r-26,0r0,-28r59,0r0,188r-33,0","w":102},"j":{"d":"55,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21xm3,44v42,-1,60,-8,60,-45r0,-159r-37,0r0,-28r71,0r0,186v-1,56,-33,76,-94,76r0,-30","w":132},"k":{"d":"145,0r-59,-94r-29,30r0,64r-33,0r0,-265r33,0r0,164r72,-87r39,0r-60,71r74,117r-37,0","w":181},"l":{"d":"60,-59v-1,20,13,33,31,33r0,30v-43,0,-65,-19,-65,-57r0,-212r34,0r0,206","w":106},"m":{"d":"162,-167v27,-44,113,-27,113,41r0,126r-33,0v-7,-59,25,-163,-39,-164v-16,0,-32,14,-37,25r0,139r-33,0r0,-134v-1,-41,-67,-34,-76,-5r0,139r-33,0r0,-188r22,0r11,22v22,-36,85,-33,105,-1","w":298},"n":{"d":"140,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110","w":196},"o":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70","w":193},"p":{"d":"188,-94v7,74,-72,123,-131,84r0,84r-33,0r0,-262r33,0r0,15v55,-48,140,0,131,79xm153,-95v9,-62,-59,-87,-96,-53r0,110v37,30,104,5,96,-57","w":200},"q":{"d":"13,-94v0,-75,78,-127,136,-80r9,-14r20,0r0,262r-34,0r0,-85v-10,10,-26,15,-49,15v-54,0,-82,-41,-82,-98xm48,-94v-7,57,56,87,96,57r0,-112v-38,-37,-102,0,-96,55","w":200},"r":{"d":"126,-156v-32,-24,-66,12,-66,48r0,108r-34,0r0,-188r34,0r0,30v17,-30,40,-40,80,-31","w":139,"k":{"\u2019":5,".":48,",":51}},"s":{"d":"92,-105v65,21,48,109,-25,109v-20,0,-39,-5,-56,-15r12,-32v19,12,34,18,45,18v21,0,31,-9,31,-26v0,-42,-90,-37,-86,-92v4,-52,67,-61,113,-36r-10,31v-20,-19,-63,-25,-68,4v-4,22,26,33,44,39","w":145},"t":{"d":"134,-2v-47,17,-98,-1,-98,-53r0,-107r-22,0r0,-26r22,0r0,-40r33,-12r0,52r52,0r0,26r-52,0v3,59,-21,164,60,131","w":142},"u":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30","w":196},"v":{"d":"92,4r-9,0r-81,-193r37,0r49,132r51,-132r35,0","w":176,"k":{".":48,",":48}},"w":{"d":"198,4r-9,0r-55,-129r-55,129r-9,0r-67,-193r35,0r41,124r50,-124r8,0r52,124r43,-124r33,0","w":267,"k":{".":38,",":38}},"x":{"d":"138,0r-51,-69r-46,69r-39,0r68,-96r-62,-92r37,0r43,64r47,-64r37,0r-69,92r75,96r-40,0","w":180},"y":{"d":"22,44v37,2,60,-26,45,-64r-65,-168r34,0r56,145r49,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30","w":177,"k":{".":44,",":44}},"z":{"d":"59,-30r105,0r0,30r-157,0r0,-9r107,-149r-105,0r0,-30r154,0r0,9","w":170},"{":{"d":"76,-56v-9,43,-30,117,48,105r0,25v-49,4,-94,-11,-94,-53v0,-36,37,-113,-23,-113r0,-15v54,-1,30,-72,23,-107v2,-40,46,-54,94,-50r0,23v-32,-1,-59,-2,-59,33v0,15,12,45,11,58v0,19,-14,35,-40,50v19,8,38,23,40,44","w":132},"|":{"d":"81,49r0,-296r26,0r0,296r-26,0"},"}":{"d":"101,21v0,41,-45,58,-94,53r0,-25v36,2,59,-8,59,-40v0,-17,-12,-50,-11,-65v2,-21,21,-36,40,-44v-53,-24,-35,-60,-29,-108v5,-35,-26,-34,-59,-33r0,-23v48,-4,92,9,94,50v-6,34,-32,106,23,107r0,15v-59,1,-23,76,-23,113","w":132},"~":{"d":"60,-126v26,-3,71,33,83,0r16,0v-7,57,-62,31,-96,23v-8,0,-15,5,-19,14r-16,0v3,-18,14,-35,32,-37"},"\u00c4":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm48,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm131,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":212},"\u00c5":{"d":"110,-319v42,0,49,66,10,73r92,246r-39,0r-18,-54r-97,0r-18,54r-39,0r98,-247v-38,-7,-31,-72,11,-72xm110,-300v-21,0,-23,35,0,35v10,0,18,-7,18,-17v0,-10,-8,-18,-18,-18xm108,-194r-40,114r77,0","w":212},"\u00c7":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132xm94,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":215},"\u00c9":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm141,-337r-40,58r-25,0r30,-58r35,0","w":192},"\u00d1":{"d":"193,4r-133,-189r0,185r-34,0r0,-258r14,0r130,179r0,-179r33,0r0,262r-10,0xm84,-315v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":229},"\u00d6":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm59,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm142,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":242},"\u00dc":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm51,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm134,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":233},"\u00e1":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm135,-284r-40,58r-25,0r30,-58r35,0","w":189},"\u00e0":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm89,-226r-39,-58r34,0r30,58r-25,0","w":189},"\u00e2":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm120,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":189},"\u00e4":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm28,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm111,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":189},"\u00e3":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm67,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":189},"\u00e5":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm53,-263v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm72,-263v0,10,9,18,18,18v11,0,18,-7,18,-18v0,-10,-8,-17,-18,-17v-9,0,-18,8,-18,17","w":189},"\u00e7":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78xm83,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":178},"\u00e9":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm145,-284r-40,58r-25,0r30,-58r35,0","w":196},"\u00e8":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm103,-226r-39,-58r34,0r30,58r-25,0","w":196},"\u00ea":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm128,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":196},"\u00eb":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm37,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm120,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":196},"\u00ed":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm95,-284r-40,58r-25,0r30,-58r35,0","w":102},"\u00ec":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm50,-226r-39,-58r34,0r30,58r-25,0","w":102},"\u00ee":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm78,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":102},"\u00ef":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm-11,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm72,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":102},"\u00f1":{"d":"140,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110xm70,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":196},"\u00f3":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm136,-284r-40,58r-25,0r30,-58r35,0","w":193},"\u00f2":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm99,-226r-39,-58r34,0r30,58r-25,0","w":193},"\u00f4":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm125,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":193},"\u00f6":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm38,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm121,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":193},"\u00f5":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm75,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":193},"\u00fa":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm130,-284r-40,58r-25,0r30,-58r35,0","w":196},"\u00f9":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm96,-226r-39,-58r34,0r30,58r-25,0","w":196},"\u00fb":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm119,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":196},"\u00fc":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm32,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm115,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":196},"\u2020":{"d":"69,-164r-65,0r0,-24r65,0r0,-55r27,0r0,55r65,0r0,24r-65,0r0,208r-13,15r-14,-15r0,-208","w":165},"\u00b0":{"d":"126,-225v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37v0,-20,17,-37,37,-37v20,0,37,16,37,37xm114,-225v0,-14,-11,-25,-25,-25v-13,0,-24,12,-24,25v0,13,11,24,24,24v13,0,25,-11,25,-24"},"\u00a2":{"d":"66,-26v-57,-32,-35,-156,44,-146r12,-42r18,0r-13,44v13,3,23,7,30,13r-13,20v-4,-4,-12,-8,-23,-10r-30,104v22,7,39,2,57,-11r10,24v-18,12,-48,18,-74,11r-13,46r-20,0xm102,-148v-38,2,-53,66,-27,94"},"\u00a3":{"d":"39,-150v-5,-63,16,-112,72,-112v24,0,41,7,51,21r-16,24v-24,-27,-80,-22,-72,39r0,28r35,0r0,26r-35,0r0,92v35,0,66,3,81,-20r24,20v-17,39,-96,32,-156,32r0,-24v30,-11,11,-65,16,-100r-14,0r0,-26r14,0"},"\u00a7":{"d":"128,-95v46,33,11,99,-49,99v-26,0,-46,-5,-61,-16r12,-33v17,22,83,28,82,-8v0,-39,-94,-29,-93,-77v0,-16,6,-28,17,-35v-14,-8,-21,-21,-21,-42v-1,-53,82,-70,120,-38r-11,33v-21,-31,-91,-19,-67,19v24,17,85,17,85,66v0,11,-5,22,-14,32xm105,-108v12,-30,-14,-45,-43,-47v-21,11,-7,35,9,39v6,2,18,4,34,8","w":163},"\u2022":{"d":"44,-101v0,-27,24,-51,51,-51v27,0,51,24,51,51v0,27,-24,51,-51,51v-27,0,-51,-24,-51,-51"},"\u00b6":{"d":"21,-189v0,-38,17,-73,54,-73r89,0r0,306r-27,0r0,-284r-28,0r0,284r-27,0r0,-157v-41,0,-61,-25,-61,-76"},"\u00df":{"d":"142,-153v73,30,43,192,-50,152r6,-26v50,17,63,-60,34,-90v-13,-13,-41,-25,-41,-47v5,-14,27,-22,27,-43v0,-19,-10,-29,-30,-29v-27,0,-31,24,-31,57r0,179r-33,0r0,-196v-1,-41,21,-66,59,-69v68,-5,80,65,43,99v0,9,11,9,16,13","w":196},"\u00ae":{"d":"137,2v-65,0,-119,-54,-119,-118v0,-64,55,-119,119,-119v64,0,119,55,119,119v0,64,-54,118,-119,118xm137,-17v53,0,99,-46,99,-99v0,-53,-46,-99,-99,-99v-53,0,-99,46,-99,99v0,53,46,99,99,99xm174,-45r-37,-62r-21,0r0,62r-21,0r0,-146v44,-2,90,0,90,41v0,19,-9,31,-28,39r40,66r-23,0xm116,-124v27,-1,48,3,48,-25v0,-21,-22,-26,-48,-24r0,49","w":256},"\u00a9":{"d":"137,2v-65,0,-119,-54,-119,-118v0,-64,55,-119,119,-119v64,0,119,55,119,119v0,64,-54,118,-119,118xm137,-17v53,0,99,-46,99,-99v0,-53,-46,-99,-99,-99v-53,0,-99,46,-99,99v0,53,46,99,99,99xm97,-115v-6,45,47,73,74,41r11,15v-41,42,-106,5,-106,-58v0,-55,50,-92,100,-68r-6,17v-35,-22,-79,9,-73,53","w":256},"\u2122":{"d":"88,-243r0,113r-18,0r0,-113r-36,0r0,-16r92,0r0,16r-38,0xm220,-130r-14,-87r-26,88r-10,0r-28,-90r-13,89r-17,0r20,-129r13,0r30,100r29,-100r13,0r20,129r-17,0","w":228},"\u00b4":{"d":"131,-284r-40,58r-25,0r30,-58r35,0"},"\u00a8":{"d":"33,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm116,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20"},"\u2260":{"d":"144,-185r25,0r-25,31r25,0r0,25r-45,0r-29,35r74,0r0,25r-94,0r-29,35r-24,0r29,-35r-30,0r0,-25r50,0r28,-35r-78,0r0,-25r98,0"},"\u00c6":{"d":"146,-54r-79,0r-25,54r-39,0r124,-258r172,0r0,32r-118,0r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-151,0r0,-54xm146,-226r-68,146r68,0r0,-146","w":312},"\u00d8":{"d":"226,-131v0,101,-80,167,-164,119r-12,16r-38,0r28,-37v-55,-72,-28,-229,75,-229v25,0,47,5,64,17r12,-17r35,0r-25,39v17,23,25,53,25,92xm115,-230v-72,-2,-78,108,-53,165r98,-151v-12,-10,-27,-14,-45,-14xm80,-40v57,38,109,-17,109,-91v0,-24,-3,-43,-10,-59","w":236},"\u221e":{"d":"180,-118v0,46,-65,52,-86,13v-21,39,-85,33,-85,-13v0,-44,64,-50,85,-15v21,-34,86,-30,86,15xm105,-118v10,14,22,20,34,20v15,0,22,-6,22,-20v0,-31,-40,-23,-56,0xm84,-118v-12,-13,-22,-20,-31,-20v-16,0,-25,6,-25,20v0,31,44,23,56,0"},"\u00b1":{"d":"107,-124r62,0r0,25r-62,0r0,60r-24,0r0,-60r-62,0r0,-25r62,0r0,-60r24,0r0,60xm169,-21r0,25r-148,0r0,-25r148,0"},"\u2264":{"d":"26,-104r0,-22r130,-62r0,28r-100,45r100,45r0,29xm169,-21r0,25r-148,0r0,-25r148,0"},"\u2265":{"d":"164,-104r-130,63r0,-29r100,-45r-100,-45r0,-28r130,62r0,22xm21,-21r148,0r0,25r-148,0r0,-25"},"\u00a5":{"d":"164,-83r-45,0r0,83r-35,0r0,-83r-43,0r0,-24r43,0r0,-8r-77,-143r36,0r58,113r65,-113r35,0r-82,143r0,8r45,0r0,24","w":205},"\u03bc":{"d":"140,-26v-10,26,-54,38,-83,23r0,77r-33,0r0,-262r33,0v5,60,-21,162,41,162v20,0,37,-12,42,-26r0,-136r33,0r0,188r-33,0r0,-26","w":196},"\u2202":{"d":"10,-82v0,-56,45,-108,94,-108v0,-16,-61,-57,-82,-53r8,-28v79,10,147,83,148,174v1,56,-34,102,-89,101v-53,0,-79,-29,-79,-86xm91,-26v62,4,66,-105,35,-136v-48,-1,-83,34,-83,80v0,33,16,54,48,56","w":197},"\u2211":{"d":"58,-226r70,96r-72,129r120,0r0,31r-161,0r0,-31r71,-129r-71,-99r0,-29r154,0r0,32r-111,0"},"\u220f":{"d":"64,-226r0,256r-35,0r0,-256r-23,0r0,-32r185,0r0,32r-23,0r0,256r-35,0r0,-256r-69,0","w":198},"\u03c0":{"d":"173,0r-34,0r0,-160r-60,0r0,160r-33,0r0,-160r-30,0r0,-28r184,0r0,28r-27,0r0,160","w":216},"\u222b":{"d":"110,-4v0,40,-22,78,-61,78v-21,0,-39,-8,-53,-22r18,-25v21,32,57,13,57,-25r0,-189v-4,-60,68,-104,116,-61r-21,25v-25,-26,-56,-13,-56,41r0,178"},"\u00aa":{"d":"15,-176v1,-32,34,-47,72,-44v2,-29,-42,-25,-55,-11r-10,-19v31,-23,96,-13,89,35v1,21,-5,51,10,58r0,12v-16,0,-27,-5,-31,-14v-18,22,-75,18,-75,-17xm39,-179v0,21,39,18,49,3r0,-27v-24,-2,-49,4,-49,24","w":132},"\u00ba":{"d":"67,-145v-34,0,-55,-24,-55,-59v0,-33,21,-59,55,-58v33,0,54,23,54,58v0,35,-20,59,-54,59xm36,-204v0,26,11,39,31,39v20,0,30,-13,30,-39v0,-26,-10,-38,-30,-38v-20,0,-31,12,-31,38","w":132},"\u03a9":{"d":"118,-262v124,0,140,186,59,236r51,0r0,26r-88,0r0,-27v31,-30,51,-53,51,-104v0,-66,-24,-99,-73,-99v-97,0,-77,172,-17,204r0,26r-88,0r0,-26r47,0v-82,-56,-52,-236,58,-236","w":240},"\u00e6":{"d":"151,-161v48,-65,173,-19,147,70r-134,0v-7,61,70,87,106,47r14,27v-27,25,-90,30,-121,4v1,6,1,12,2,17r-29,0v-2,-8,-2,-9,-6,-26v-27,42,-116,31,-116,-27v0,-52,58,-82,113,-67v6,-54,-64,-55,-89,-29r-14,-28v30,-26,112,-26,127,12xm269,-115v3,-44,-62,-66,-90,-33v-10,11,-15,22,-15,33r105,0xm127,-92v-35,-14,-80,9,-80,40v0,42,63,35,80,5r0,-45","w":314},"\u00f8":{"d":"160,-164v44,55,18,168,-64,168v-19,0,-36,-5,-49,-14r-10,14r-26,0r21,-29v-44,-55,-17,-167,64,-167v19,0,36,5,49,14r10,-14r26,0xm126,-153v-40,-28,-82,6,-82,58v0,17,3,32,8,43xm66,-35v39,31,82,-8,82,-60v0,-17,-3,-30,-8,-41","w":196},"\u00bf":{"d":"98,-165v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26v0,-14,12,-27,26,-27v14,0,27,13,27,27xm121,59v-43,36,-139,5,-109,-64v15,-36,66,-53,52,-108r23,0v28,61,-42,83,-47,129v-4,34,49,40,68,18","w":132},"\u00a1":{"d":"94,-165v0,13,-13,26,-26,26v-14,0,-27,-12,-27,-26v0,-14,13,-27,27,-27v14,0,26,13,26,27xm73,-121v15,97,13,113,13,195r-39,0v0,-81,-2,-100,13,-195r13,0","w":132},"\u00ac":{"d":"169,-156r0,86r-25,0r0,-61r-123,0r0,-25r148,0"},"\u221a":{"d":"132,-237r-67,237r-25,0r-37,-47r17,-15r26,34r66,-231r79,0r0,22r-59,0"},"\u0192":{"d":"141,-234v-36,-14,-56,3,-62,46v16,0,29,0,44,-2r-3,21v-20,3,-35,4,-46,5r-29,177v-5,33,-34,58,-67,58r-9,-27v16,-2,39,-16,42,-31r30,-176v-5,0,-14,1,-27,3r5,-28r26,0v12,-60,47,-89,102,-72","w":139},"\u2248":{"d":"60,-147v24,-2,72,33,83,0r16,0v-8,57,-61,23,-96,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-34,32,-36xm60,-89v24,-2,72,33,83,0r16,0v-8,57,-61,23,-96,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-34,32,-36"},"\u0394":{"d":"4,0r0,-22r93,-236r25,0r85,236r0,22r-203,0xm109,-214r-66,184r127,0","w":210},"\u00ab":{"d":"23,-94r0,-11r62,-43r0,22r-37,27r37,25r0,22xm93,-94r0,-11r62,-43r0,22r-37,27r37,25r0,22"},"\u00bb":{"d":"92,-94r-62,42r0,-22r37,-25r-37,-27r0,-22r62,43r0,11xm162,-94r-62,42r0,-22r37,-25r-37,-27r0,-22r62,43r0,11"},"\u2026":{"d":"44,-49v14,0,26,11,26,26v0,15,-12,27,-26,27v-14,0,-26,-12,-26,-27v0,-14,11,-26,26,-26xm132,-49v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-14,12,-26,26,-26xm220,-49v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-14,12,-26,26,-26","w":264},"\u00a0":{"w":108},"\u00c0":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm101,-279r-39,-58r34,0r30,58r-25,0","w":212},"\u00c3":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm84,-315v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":212},"\u00d5":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm96,-315v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":242},"\u0152":{"d":"12,-131v0,-68,38,-131,103,-131v32,0,57,9,76,27r0,-23r154,0r0,32r-119,0r0,72r85,0r0,30r-85,0r0,92r117,0r0,32r-152,0r0,-24v-19,19,-44,28,-76,28v-68,0,-103,-62,-103,-135xm115,-230v-49,0,-66,45,-66,99v-1,52,20,104,66,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99","w":357},"\u0153":{"d":"11,-95v0,-55,33,-97,85,-97v32,0,55,12,70,35v45,-69,174,-27,151,66r-134,0v-7,61,67,85,105,49r14,26v-33,28,-114,29,-138,-14v-15,23,-38,34,-68,34v-55,0,-85,-42,-85,-99xm288,-115v2,-44,-58,-65,-89,-34v-10,11,-16,22,-16,34r105,0xm96,-162v-34,0,-51,29,-50,67v0,45,17,69,50,69v34,-1,51,-31,50,-69v0,-45,-17,-67,-50,-67","w":332},"\u2013":{"d":"16,-94r0,-16r92,0r0,16r-92,0","w":132},"\u2014":{"d":"16,-94r0,-16r230,0r0,16r-230,0","w":264},"\u201c":{"d":"154,-239v-24,18,7,37,7,55v0,17,-8,26,-25,26v-18,0,-28,-10,-28,-31v0,-31,16,-56,47,-76r12,15xm75,-239v-23,18,3,39,7,55v0,17,-8,26,-25,26v-18,0,-28,-10,-28,-31v0,-31,16,-56,47,-76r12,15"},"\u201d":{"d":"123,-185v23,-18,-8,-39,-8,-55v0,-17,9,-25,26,-25v18,0,27,10,27,31v0,31,-16,56,-47,76r-11,-16xm42,-185v24,-18,-5,-38,-8,-55v0,-17,9,-25,26,-25v18,0,27,10,27,31v0,31,-15,56,-46,76r-12,-16"},"\u2018":{"d":"84,-239v-24,18,4,38,8,55v0,17,-9,26,-26,26v-18,0,-27,-10,-27,-31v0,-31,15,-56,46,-76r12,15","w":132,"k":{"\u2018":35}},"\u2019":{"d":"48,-185v24,-18,-7,-37,-7,-55v0,-17,8,-25,25,-25v18,0,27,10,27,31v0,31,-15,56,-46,76r-12,-16","w":132,"k":{"\u2019":35,"s":25," ":13}},"\u00f7":{"d":"96,-202v13,0,26,13,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27v0,-14,13,-26,27,-26xm169,-124r0,25r-148,0r0,-25r148,0xm96,-70v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27v0,-14,12,-26,27,-26"},"\u25ca":{"d":"97,-250r73,125r-73,125r-20,0r-69,-125r69,-125r20,0xm87,-233r-60,108r60,108r63,-108","w":177},"\u00ff":{"d":"22,44v37,2,60,-26,45,-64r-65,-168r34,0r56,145r49,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30xm26,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm109,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":177},"\u0178":{"d":"120,-115r0,115r-35,0r0,-115r-83,-143r36,0r65,113r64,-113r36,0xm42,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm125,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":205},"\u2044":{"d":"23,6r-22,0r171,-268r22,0","w":190},"\u2215":{"d":"23,6r-22,0r171,-268r22,0","w":190},"\u20ac":{"d":"26,-163v6,-52,43,-100,97,-99v29,0,50,5,62,16r-16,29v-24,-18,-70,-19,-89,7v-9,13,-16,28,-19,47r81,0r-11,25r-72,0r-1,23r61,0r-8,24r-50,0v2,30,30,64,60,64v23,0,48,-13,60,-25r0,38v-16,12,-38,18,-64,18v-51,0,-85,-45,-91,-95r-21,0r0,-24r18,0v-1,-8,-1,-16,-1,-23r-17,0r0,-25r21,0"},"\u2039":{"d":"30,-94r0,-11r62,-43r0,22r-37,27r37,25r0,22","w":132},"\u203a":{"d":"99,-94r-62,42r0,-22r37,-25r-37,-27r0,-22r62,43r0,11","w":132},"\uf001":{"d":"123,-236v-33,-12,-60,13,-53,48r112,0r0,188r-34,0r0,-160r-78,0r0,160r-33,0r0,-160r-28,0r0,-28r28,0v-3,-57,40,-91,96,-72xm141,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21","w":208},"\ufb01":{"d":"123,-236v-33,-12,-60,13,-53,48r112,0r0,188r-34,0r0,-160r-78,0r0,160r-33,0r0,-160r-28,0r0,-28r28,0v-3,-57,40,-91,96,-72xm141,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21","w":208},"\uf002":{"d":"39,-188v-6,-60,53,-94,104,-69r0,-5r34,0r0,203v0,22,8,33,24,33r0,30v-42,0,-58,-16,-58,-57r0,-173v-25,-26,-84,-9,-71,38r33,0r0,28r-33,0r0,160r-33,0r0,-160r-28,0r0,-28r28,0","w":216},"\ufb02":{"d":"39,-188v-6,-60,53,-94,104,-69r0,-5r34,0r0,203v0,22,8,33,24,33r0,30v-42,0,-58,-16,-58,-57r0,-173v-25,-26,-84,-9,-71,38r33,0r0,28r-33,0r0,160r-33,0r0,-160r-28,0r0,-28r28,0","w":216},"\u2021":{"d":"161,-67r0,25r-65,0r0,86r-14,16r-13,-16r0,-86r-65,0r0,-25r65,0r0,-97r-65,0r0,-24r65,0r0,-55r27,0r0,55r65,0r0,24r-65,0r0,97r65,0","w":165},"\u2219":{"d":"36,-114v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26","w":132},"\u201a":{"d":"48,31v24,-18,-7,-36,-7,-54v0,-17,8,-26,25,-26v18,0,27,10,27,31v0,31,-15,56,-46,76r-12,-15","w":132},"\u201e":{"d":"123,31v23,-18,-8,-38,-8,-54v0,-17,9,-26,26,-26v18,0,27,10,27,31v0,31,-16,56,-47,76r-11,-15xm42,31v24,-18,-8,-37,-8,-54v0,-17,9,-26,26,-26v18,0,27,10,27,31v0,31,-15,56,-46,76r-12,-15"},"\u2030":{"d":"38,4r-22,0r155,-266r22,0xm109,-201v0,33,-18,60,-49,60v-33,0,-49,-21,-49,-63v0,-32,19,-59,50,-58v31,0,48,26,48,61xm61,-244v-20,0,-28,20,-28,42v0,22,7,43,25,43v19,0,28,-14,28,-43v0,-28,-8,-42,-25,-42xm204,-56v0,33,-19,59,-49,60v-33,0,-49,-21,-49,-63v0,-32,19,-59,50,-58v31,0,48,26,48,61xm156,-99v-20,0,-29,19,-28,41v0,23,7,44,25,44v19,0,28,-14,28,-43v0,-28,-8,-42,-25,-42xm318,-56v0,33,-19,59,-49,60v-33,0,-49,-21,-49,-63v0,-32,19,-59,50,-58v31,0,48,26,48,61xm270,-99v-38,-1,-37,85,-3,85v19,0,29,-14,29,-43v0,-28,-9,-42,-26,-42","w":328},"\u00c2":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm137,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":212},"\u00ca":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm126,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":192},"\u00c1":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm151,-337r-40,58r-25,0r30,-58r35,0","w":212},"\u00cb":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm40,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm123,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":192},"\u00c8":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm104,-279r-39,-58r34,0r30,58r-25,0","w":192},"\u00cd":{"d":"33,0r0,-258r35,0r0,258r-35,0xm102,-337r-40,58r-25,0r30,-58r35,0","w":100},"\u00ce":{"d":"33,0r0,-258r35,0r0,258r-35,0xm76,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":100},"\u00cf":{"d":"33,0r0,-258r35,0r0,258r-35,0xm-6,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm77,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":100},"\u00cc":{"d":"33,0r0,-258r35,0r0,258r-35,0xm58,-279r-39,-58r34,0r30,58r-25,0","w":100},"\u00d3":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm156,-337r-40,58r-25,0r30,-58r35,0","w":242},"\u00d4":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm146,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":242},"\uf000":{"d":"22,-62r0,-135r136,0r0,135r-136,0xm45,-84r90,0r0,-90r-90,0r0,90","w":180},"\u00d2":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm126,-279r-39,-58r34,0r30,58r-25,0","w":242},"\u00da":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm150,-337r-40,58r-25,0r30,-58r35,0","w":233},"\u00db":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm139,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":233},"\u00d9":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm116,-279r-39,-58r34,0r30,58r-25,0","w":233},"\u0131":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0","w":102},"\u02c6":{"d":"120,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0"},"\u02dc":{"d":"68,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36"},"\u02c9":{"d":"160,-251r0,25r-129,0r0,-25r129,0"},"\u02d8":{"d":"92,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30"},"\u02d9":{"d":"73,-247v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21"},"\u02da":{"d":"52,-263v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm71,-263v0,10,9,18,18,18v11,0,18,-7,18,-18v0,-10,-8,-17,-18,-17v-9,0,-18,8,-18,17"},"\u00b8":{"d":"74,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21"},"\u02dd":{"d":"95,-276r-35,50r-25,0r25,-50r35,0xm160,-276r-35,50r-25,0r25,-50r35,0"},"\u02db":{"d":"104,0v-22,5,-24,41,3,40v6,0,13,-2,19,-6r11,25v-74,35,-108,-60,-43,-87"},"\u02c7":{"d":"155,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0"},"\u0141":{"d":"85,-184r0,23r-23,17r0,112r116,0r0,32r-152,0r0,-119r-26,18r0,-25r26,-18r0,-114r36,0r0,90","w":182},"\u0142":{"d":"61,-144v4,45,-16,117,31,118r0,30v-72,4,-67,-58,-65,-124r-18,13r0,-26r18,-12r0,-120r34,0r0,97v4,-3,4,-3,24,-16r0,23","w":107},"\u0160":{"d":"111,-139v78,32,52,143,-38,143v-23,0,-42,-5,-58,-16r13,-32v27,24,96,25,96,-23v0,-53,-79,-52,-99,-88v-27,-49,5,-107,62,-107v28,0,48,5,59,14r-10,31v-24,-19,-89,-24,-87,21v1,38,32,45,62,57xm151,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":173},"\u0161":{"d":"92,-105v65,21,48,109,-25,109v-20,0,-39,-5,-56,-15r12,-32v19,12,34,18,45,18v21,0,31,-9,31,-26v0,-42,-90,-37,-86,-92v4,-52,67,-61,113,-36r-10,31v-20,-19,-63,-25,-68,4v-4,22,26,33,44,39xm134,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":145},"\u017d":{"d":"18,0r0,-9r110,-217r-109,0r0,-32r158,0r0,9r-111,217r115,0r0,32r-163,0xm158,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":198},"\u017e":{"d":"59,-30r105,0r0,30r-157,0r0,-9r107,-149r-105,0r0,-30r154,0r0,9xm146,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":170},"\u00a6":{"d":"83,-122r0,-127r26,0r0,127r-26,0xm83,49r0,-128r26,0r0,128r-26,0"},"\u00d0":{"d":"26,-258v117,-14,177,23,181,119v4,114,-65,149,-181,139r0,-121r-23,0r0,-29r23,0r0,-108xm62,-33v73,11,108,-32,108,-103v0,-71,-38,-101,-108,-90r0,76r26,0r0,29r-26,0r0,88","w":220},"\u00f0":{"d":"11,-95v0,-63,44,-110,111,-94v-8,-13,-15,-24,-21,-32r-30,17r-8,-16r28,-15v-11,-13,-21,-22,-31,-30r44,0v3,4,8,9,14,16r30,-16r8,15r-28,15v34,54,51,76,53,140v2,57,-30,99,-85,99v-55,0,-85,-42,-85,-99xm96,-162v-35,1,-52,30,-52,67v0,45,17,69,52,69v36,-1,52,-31,52,-69v0,-45,-18,-67,-52,-67","w":197},"\u00dd":{"d":"120,-115r0,115r-35,0r0,-115r-83,-143r36,0r65,113r64,-113r36,0xm144,-337r-40,58r-25,0r30,-58r35,0","w":205},"\u00de":{"d":"187,-146v-1,68,-50,97,-125,91r0,55r-36,0r0,-258r36,0r0,34v77,-3,126,22,125,78xm151,-142v0,-46,-38,-51,-89,-50r0,105v52,3,89,-10,89,-55","w":200},"\u00fe":{"d":"188,-94v8,73,-73,124,-131,84r0,84r-33,0r0,-339r33,0r0,92v55,-48,140,0,131,79xm153,-95v9,-61,-60,-85,-96,-51r0,106v40,32,104,6,96,-55","w":199},"\u2212":{"d":"169,-124r0,25r-148,0r0,-25r148,0"},"\u00b9":{"d":"77,-105r0,-118r-33,20r0,-20v23,-12,40,-24,50,-37r6,0r0,155r-23,0","w":162},"\u00b2":{"d":"28,-232v5,-15,24,-30,43,-30v91,0,20,106,-2,137r58,0r0,20r-95,0v14,-40,62,-72,62,-116v0,-31,-45,-25,-52,1","w":162},"\u00b3":{"d":"69,-262v48,0,61,62,22,75v19,6,29,20,29,40v0,45,-60,55,-87,32r10,-18v14,15,58,12,55,-16v-2,-18,-12,-29,-33,-29v1,-5,-2,-14,1,-17v17,0,26,-9,26,-25v0,-24,-35,-26,-46,-13r-9,-16v7,-9,17,-13,32,-13","w":163},"\u00bd":{"d":"59,6r-22,0r171,-268r22,0xm51,-105r0,-118r-33,20r0,-20v23,-12,39,-24,49,-37r7,0r0,155r-23,0xm176,-127v4,-16,22,-31,42,-30v92,7,20,106,-2,136r59,0r0,21r-95,0v14,-40,62,-72,62,-116v0,-31,-45,-28,-52,0","w":293},"\u00bc":{"d":"61,6r-22,0r171,-268r22,0xm46,-105r0,-116r-32,18r0,-20v23,-12,40,-24,50,-37r6,0r0,155r-24,0xm246,-37r0,37r-23,0r0,-37r-71,0r0,-12r87,-106r7,0r0,100r16,0r0,18r-16,0xm223,-110r-44,55r44,0r0,-55","w":293},"\u00be":{"d":"75,6r-22,0r171,-268r22,0xm59,-262v48,0,61,62,22,75v46,13,37,84,-23,84v-15,0,-27,-4,-36,-12r10,-18v14,15,58,12,55,-16v-2,-19,-12,-29,-32,-29v1,-5,-2,-14,1,-17v17,0,26,-9,26,-25v0,-23,-35,-27,-46,-13r-10,-16v7,-9,18,-13,33,-13xm251,-37r0,37r-22,0r0,-37r-71,0r0,-12r86,-106r7,0r0,100r16,0r0,18r-16,0xm229,-110r-45,55r45,0r0,-55","w":293},"\u00b5":{"d":"140,-26v-10,26,-54,38,-83,23r0,77r-33,0r0,-262r33,0v5,60,-21,162,41,162v20,0,37,-12,42,-26r0,-136r33,0r0,188r-33,0r0,-26","w":196},"\u2126":{"d":"118,-262v124,0,140,186,59,236r51,0r0,26r-88,0r0,-27v31,-30,51,-53,51,-104v0,-66,-24,-99,-73,-99v-97,0,-77,172,-17,204r0,26r-88,0r0,-26r47,0v-82,-56,-52,-236,58,-236","w":240},"\u2206":{"d":"4,0r0,-22r93,-236r25,0r85,236r0,22r-203,0xm109,-214r-66,184r127,0","w":210},"\u00fd":{"d":"22,44v37,2,60,-26,45,-64r-65,-168r34,0r56,145r49,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30xm133,-284r-40,58r-25,0r30,-58r35,0","w":177},"\u00d7":{"d":"96,-128r55,-56r18,18r-56,55r55,56r-17,17r-55,-55r-56,56r-18,-18r56,-55r-56,-57r17,-17"},"\u00ad":{"d":"28,-89r0,-31r75,0r0,31r-75,0","w":132},"\uf006":{"d":"3,44v42,-1,60,-8,60,-45r0,-159r-37,0r0,-28r71,0r0,186v-1,56,-33,76,-94,76r0,-30","w":132},"\uf007":{"d":"68,-271v-1,11,15,17,15,28v0,11,-7,17,-19,17v-13,0,-19,-8,-19,-25v0,-20,9,-37,27,-51r10,10v-9,10,-13,11,-14,21","w":132},"\u20a3":{"d":"62,-226r0,72r90,0r0,30r-90,0r0,36r26,0r0,28r-26,0r0,60r-36,0r0,-60r-23,0r0,-28r23,0r0,-170r159,0r0,32r-123,0"},"\u011e":{"d":"14,-128v0,-104,109,-172,191,-112r-15,29v-65,-50,-139,4,-139,85v0,76,74,127,131,82r0,-60r-36,0r0,-30r71,0r0,112v-16,15,-57,26,-88,26v-73,1,-115,-56,-115,-132xm125,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":243},"\u011f":{"d":"170,16v0,66,-110,71,-153,36r18,-27v19,13,38,19,54,19v24,0,49,-7,49,-27v0,-52,-120,14,-117,-47v0,-15,18,-25,33,-28v-66,-24,-43,-134,31,-134v19,0,34,4,44,12r17,-20r21,20r-20,15v33,44,-1,116,-51,114v-18,3,-45,0,-49,15v6,16,48,2,64,2v36,0,59,16,59,50xm126,-123v0,-23,-16,-42,-38,-42v-24,-1,-40,19,-40,42v0,25,15,47,40,46v24,-1,38,-20,38,-46xm81,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":180},"\u0130":{"d":"33,0r0,-258r35,0r0,258r-35,0xm29,-300v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":100},"\u015e":{"d":"111,-139v78,32,52,143,-38,143v-23,0,-42,-5,-58,-16r13,-32v27,24,96,25,96,-23v0,-53,-79,-52,-99,-88v-27,-49,5,-107,62,-107v28,0,48,5,59,14r-10,31v-24,-19,-89,-24,-87,21v1,38,32,45,62,57xm65,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":173},"\u015f":{"d":"92,-105v65,21,48,109,-25,109v-20,0,-39,-5,-56,-15r12,-32v19,12,34,18,45,18v21,0,31,-9,31,-26v0,-42,-90,-37,-86,-92v4,-52,67,-61,113,-36r-10,31v-20,-19,-63,-25,-68,4v-4,22,26,33,44,39xm51,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":145},"\u0106":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132xm168,-337r-40,58r-25,0r30,-58r35,0","w":215},"\u0107":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78xm147,-284r-40,58r-25,0r30,-58r35,0","w":178},"\u010c":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132xm185,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":215},"\u010d":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78xm162,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":178},"\u0111":{"d":"13,-89v-6,-69,71,-132,130,-89r0,-31r-44,0r0,-27r44,0r0,-29r33,0r0,29r21,0r0,27r-21,0r0,209r-33,0r0,-14v-52,43,-140,-1,-130,-75xm48,-93v-8,60,62,85,95,51r0,-101v-31,-45,-101,-3,-95,50","w":200},"\u00af":{"d":"-1,-271r0,-23r190,0r0,23r-190,0"},"\uf005":{"d":"44,-201v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":132},"\u00b7":{"d":"36,-114v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26","w":132},"\u0102":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm107,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":212},"\u0103":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm88,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":189},"\u0104":{"d":"200,0v-24,2,-20,41,3,40v6,0,13,-2,19,-6r12,25v-35,17,-80,2,-79,-37v0,-13,4,-24,14,-32r-14,-44r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-12,0xm145,-80r-37,-114r-40,114r77,0","w":212},"\u0105":{"d":"82,-192v83,0,81,66,78,146v0,17,5,27,15,33r0,16v-15,-2,-19,9,-19,20v-2,19,25,21,38,11r12,25v-35,17,-80,2,-79,-37v0,-11,3,-21,10,-30v-3,-3,-5,-8,-7,-14v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45","w":189},"\u010e":{"d":"26,-258v117,-14,177,23,181,119v4,114,-65,149,-181,139r0,-258xm62,-33v73,11,108,-32,108,-103v0,-71,-38,-101,-108,-90r0,193xm166,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":220},"\u010f":{"d":"13,-89v-6,-69,71,-132,130,-89r0,-87r33,0r0,265r-33,0r0,-14v-52,43,-140,-1,-130,-75xm48,-93v-7,60,58,86,95,53r0,-105v-32,-45,-102,-2,-95,52xm209,-201v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":248},"\u0110":{"d":"26,-258v117,-14,177,23,181,119v4,114,-65,149,-181,139r0,-121r-23,0r0,-29r23,0r0,-108xm62,-33v73,11,108,-32,108,-103v0,-71,-38,-101,-108,-90r0,76r26,0r0,29r-26,0r0,88","w":220},"\u0118":{"d":"178,0v-25,-2,-45,1,-45,23v0,19,26,21,39,11r11,25v-42,23,-97,-13,-73,-59r-84,0r0,-258r154,0r0,32r-118,0r0,72r85,0r0,30r-85,0r0,92r116,0r0,32","w":192},"\u0119":{"d":"168,-14v-15,20,-65,4,-66,37v-1,19,25,21,38,11r12,25v-42,21,-95,-9,-75,-58v-39,-10,-66,-44,-66,-93v0,-56,38,-99,89,-100v57,-1,95,43,82,101r-135,0v-7,61,66,84,107,50xm152,-115v3,-45,-59,-64,-88,-35v-10,9,-16,21,-17,35r105,0","w":196},"\u011a":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm166,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":192},"\u011b":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm160,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":196},"\u0139":{"d":"26,0r0,-258r36,0r0,226r116,0r0,32r-152,0xm106,-337r-40,58r-25,0r30,-58r35,0","w":182},"\u013a":{"d":"60,-59v-1,20,13,33,31,33r0,30v-43,0,-65,-19,-65,-57r0,-212r34,0r0,206xm96,-337r-40,58r-25,0r30,-58r35,0","w":106},"\u013d":{"d":"26,0r0,-258r36,0r0,226r116,0r0,32r-152,0xm95,-198v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":182},"\u013e":{"d":"60,-59v-1,20,13,33,31,33r0,30v-43,0,-65,-19,-65,-57r0,-212r34,0r0,206xm84,-201v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":106},"\u013f":{"d":"26,0r0,-258r36,0r0,226r116,0r0,32r-152,0xm101,-129v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":182},"\u0140":{"d":"60,-59v-1,20,13,33,31,33r0,30v-43,0,-65,-19,-65,-57r0,-212r34,0r0,206xm91,-136v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":118},"\u0143":{"d":"193,4r-133,-189r0,185r-34,0r0,-258r14,0r130,179r0,-179r33,0r0,262r-10,0xm152,-337r-40,58r-25,0r30,-58r35,0","w":229},"\u0144":{"d":"140,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110xm140,-284r-40,58r-25,0r30,-58r35,0","w":196},"\u0147":{"d":"193,4r-133,-189r0,185r-34,0r0,-258r14,0r130,179r0,-179r33,0r0,262r-10,0xm169,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":229},"\u0148":{"d":"140,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110xm164,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":196},"\u0150":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm132,-329r-35,50r-25,0r25,-50r35,0xm197,-329r-35,50r-25,0r25,-50r35,0","w":242},"\u0151":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm109,-276r-35,50r-25,0r25,-50r35,0xm174,-276r-35,50r-25,0r25,-50r35,0","w":193},"\u0154":{"d":"185,-186v0,31,-24,62,-50,68r75,118r-41,0r-68,-111v-8,0,-21,0,-38,-1r0,112r-35,0r0,-258v76,-7,157,-1,157,72xm148,-187v0,-40,-42,-44,-85,-39r0,84v43,5,85,1,85,-45xm131,-337r-40,58r-25,0r30,-58r35,0","w":209},"\u0155":{"d":"126,-156v-32,-24,-66,12,-66,48r0,108r-34,0r0,-188r34,0r0,30v17,-30,40,-40,80,-31xm122,-284r-40,58r-25,0r30,-58r35,0","w":139},"\u0158":{"d":"185,-186v0,31,-24,62,-50,68r75,118r-41,0r-68,-111v-8,0,-21,0,-38,-1r0,112r-35,0r0,-258v76,-7,157,-1,157,72xm148,-187v0,-40,-42,-44,-85,-39r0,84v43,5,85,1,85,-45xm162,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":209},"\u0159":{"d":"126,-156v-32,-24,-66,12,-66,48r0,108r-34,0r0,-188r34,0r0,30v17,-30,40,-40,80,-31xm143,-285r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":139},"\u015a":{"d":"111,-139v78,32,52,143,-38,143v-23,0,-42,-5,-58,-16r13,-32v27,24,96,25,96,-23v0,-53,-79,-52,-99,-88v-27,-49,5,-107,62,-107v28,0,48,5,59,14r-10,31v-24,-19,-89,-24,-87,21v1,38,32,45,62,57xm134,-337r-40,58r-25,0r30,-58r35,0","w":173},"\u015b":{"d":"92,-105v65,21,48,109,-25,109v-20,0,-39,-5,-56,-15r12,-32v19,12,34,18,45,18v21,0,31,-9,31,-26v0,-42,-90,-37,-86,-92v4,-52,67,-61,113,-36r-10,31v-20,-19,-63,-25,-68,4v-4,22,26,33,44,39xm115,-284r-40,58r-25,0r30,-58r35,0","w":145},"\u0162":{"d":"120,-226r0,226r-35,0r0,-226r-82,0r0,-32r203,0r0,32r-86,0xm81,84v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":209},"\u0163":{"d":"134,-2v-47,17,-98,-1,-98,-53r0,-107r-22,0r0,-26r22,0r0,-40r33,-12r0,52r52,0r0,26r-52,0v3,59,-21,164,60,131xm60,84v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":142},"\u0164":{"d":"120,-226r0,226r-35,0r0,-226r-82,0r0,-32r203,0r0,32r-86,0xm167,-338r-54,59r-19,0r-52,-59r30,0r31,33r29,-33r35,0","w":209},"\u0165":{"d":"134,-2v-47,17,-98,-1,-98,-53r0,-107r-22,0r0,-26r22,0r0,-40r33,-12r0,52r52,0r0,26r-52,0v3,59,-21,164,60,131xm134,-178v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54","w":178},"\u016e":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm82,-298v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm101,-298v0,10,9,18,18,18v11,0,18,-7,18,-18v0,-10,-8,-17,-18,-17v-9,0,-18,8,-18,17","w":233},"\u016f":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm66,-263v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm85,-263v0,10,9,18,18,18v11,0,18,-7,18,-18v0,-10,-8,-17,-18,-17v-9,0,-18,8,-18,17","w":196},"\u0170":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm127,-329r-35,50r-25,0r25,-50r35,0xm192,-329r-35,50r-25,0r25,-50r35,0","w":233},"\u0171":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm111,-276r-35,50r-25,0r25,-50r35,0xm176,-276r-35,50r-25,0r25,-50r35,0","w":196},"\u0179":{"d":"18,0r0,-9r110,-217r-109,0r0,-32r158,0r0,9r-111,217r115,0r0,32r-163,0xm124,-337r-40,58r-25,0r30,-58r35,0","w":198},"\u017a":{"d":"59,-30r105,0r0,30r-157,0r0,-9r107,-149r-105,0r0,-30r154,0r0,9xm119,-284r-40,58r-25,0r30,-58r35,0","w":170},"\u017b":{"d":"18,0r0,-9r110,-217r-109,0r0,-32r158,0r0,9r-111,217r115,0r0,32r-163,0xm66,-300v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":198},"\u017c":{"d":"59,-30r105,0r0,30r-157,0r0,-9r107,-149r-105,0r0,-30r154,0r0,9xm66,-247v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":170},"\u00a4":{"d":"164,-43r-25,-26v-28,20,-61,20,-89,0r-25,26r-15,-16r25,-24v-19,-30,-19,-59,0,-89r-25,-24r15,-16r25,25v28,-19,61,-19,89,0r25,-25r15,16r-25,24v19,30,19,59,0,89r25,24xm94,-180v-29,0,-53,24,-53,52v0,29,23,53,53,53v30,0,53,-24,53,-53v0,-29,-24,-52,-53,-52"},"\u037e":{"d":"36,-165v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26xm66,-49v30,2,30,49,15,71v-7,12,-21,26,-42,42r-9,-13v20,-17,31,-30,31,-42v0,-16,-23,-22,-21,-36v-1,-13,12,-23,26,-22","w":132},"\u0384":{"d":"128,-284r-31,58r-28,0r20,-58r39,0"},"\u0385":{"d":"118,-284r-20,62r-21,0r10,-62r31,0xm125,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm43,-267v11,0,20,9,20,20v1,11,-8,20,-19,20v-11,0,-21,-9,-21,-20v0,-11,9,-20,20,-20"},"\u0386":{"d":"172,0r-17,-54r-96,0r-19,54r-39,0r104,-261r9,0r98,261r-40,0xm108,-194r-40,114r77,0xm66,-257r-29,61r-27,0r17,-61r39,0","w":212},"\u0387":{"d":"36,-115v0,-15,13,-27,27,-27v14,0,26,13,26,27v0,13,-12,27,-26,27v-14,0,-27,-13,-27,-27","w":132},"\u0388":{"d":"101,-226r0,71r85,0r0,30r-85,0r0,93r117,0r0,32r-152,0r0,-257r154,0r0,31r-119,0xm39,-257r-29,61r-27,0r18,-61r38,0","w":232},"\u0389":{"d":"213,0r0,-125r-112,0r0,125r-35,0r0,-257r35,0r0,102r112,0r0,-102r36,0r0,257r-36,0xm39,-257r-29,61r-27,0r18,-61r38,0","w":275},"\u038a":{"d":"66,0r0,-257r35,0r0,257r-35,0xm39,-257r-29,61r-27,0r18,-61r38,0","w":133},"\u038c":{"d":"136,4v-70,0,-106,-61,-104,-135v2,-72,33,-131,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm136,-230v-48,0,-68,43,-67,99v1,52,18,104,67,104v53,-1,75,-45,74,-104v0,-66,-25,-99,-74,-99xm39,-257r-29,61r-27,0r18,-61r38,0","w":260},"\u038e":{"d":"176,-115r0,115r-34,0r0,-115r-84,-142r37,0r64,112r64,-112r36,0xm39,-257r-29,61r-27,0r18,-61r38,0","w":256},"\u038f":{"d":"143,-263v122,-5,133,173,62,235v11,-1,28,-2,50,-2r0,30r-98,0r0,-9v29,-39,55,-71,56,-130v0,-55,-20,-92,-71,-93v-47,0,-71,41,-70,91v1,58,27,92,56,132r0,9r-97,0r0,-30v21,0,38,1,49,2v-77,-76,-53,-231,63,-235xm39,-257r-29,61r-27,0r18,-61r38,0","w":267},"\u0390":{"d":"85,3v-90,4,-49,-115,-58,-191r33,0r0,133v0,19,9,29,25,30r0,28xm70,-284r-21,62r-20,0r10,-62r31,0xm77,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm-24,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20","w":100},"\u0391":{"d":"172,0r-17,-54r-96,0r-19,54r-39,0r104,-261r9,0r98,261r-40,0xm108,-194r-40,114r77,0","w":212},"\u0392":{"d":"190,-75v1,75,-83,80,-164,75r0,-257v77,-7,145,-9,148,61v1,24,-23,46,-43,51v39,9,59,32,59,70xm62,-229r0,73v37,5,82,-2,77,-39v3,-35,-39,-40,-77,-34xm153,-80v0,-48,-34,-53,-91,-48r0,98v51,6,91,0,91,-50","w":203},"\u0393":{"d":"176,-226r-114,0r0,226r-36,0r0,-257r150,0r0,31","w":183},"\u0395":{"d":"62,-226r0,71r85,0r0,30r-85,0r0,93r116,0r0,32r-152,0r0,-257r154,0r0,31r-118,0","w":193},"\u0396":{"d":"18,0r0,-9r110,-217r-108,0r0,-31r157,0r0,8r-111,217r114,0r0,32r-162,0","w":197},"\u0397":{"d":"174,0r0,-125r-112,0r0,125r-36,0r0,-257r36,0r0,102r112,0r0,-102r35,0r0,257r-35,0","w":235},"\u0398":{"d":"14,-131v1,-74,38,-131,111,-131v73,0,109,56,110,131v1,77,-41,134,-111,135v-72,0,-112,-57,-110,-135xm50,-131v0,59,22,104,75,104v55,0,73,-42,73,-104v0,-58,-21,-100,-74,-100v-52,0,-74,44,-74,100xm175,-117r-102,0r0,-31r102,0r0,31","w":248},"\u0399":{"d":"32,0r0,-257r36,0r0,257r-36,0","w":100},"\u039a":{"d":"168,0r-72,-118r-34,48r0,70r-36,0r0,-257r36,0r0,140r95,-140r39,0r-76,111r87,146r-39,0","w":207},"\u039b":{"d":"210,0r-40,0r-63,-188r-66,188r-40,0r102,-261r10,0","w":210},"\u039c":{"d":"220,0r-30,-165r-56,169r-9,0r-58,-169r-30,165r-33,0r48,-257r16,0r61,188r57,-188r16,0r52,257r-34,0","w":255},"\u039d":{"d":"193,4r-133,-189r0,185r-34,0r0,-257r14,0r130,177r0,-177r33,0r0,261r-10,0","w":229},"\u039e":{"d":"197,0r-179,0r0,-30r72,0r0,-95r-52,0r0,-28r52,0r0,-75r-70,0r0,-29r175,0r0,29r-70,0r0,75r52,0r0,28r-52,0r0,95r72,0r0,30","w":214},"\u039f":{"d":"118,4v-70,0,-104,-61,-104,-135v0,-69,37,-132,104,-131v75,1,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-48,0,-67,43,-67,99v0,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99","w":242},"\u03a0":{"d":"202,0r-35,0r0,-226r-105,0r0,226r-36,0r0,-257r176,0r0,257","w":228},"\u03a1":{"d":"62,-99r0,99r-36,0r0,-257v86,-9,161,7,161,73v0,67,-49,92,-125,85xm62,-226r0,95v46,7,93,-7,88,-49v4,-37,-39,-52,-88,-46","w":200},"\u03a3":{"d":"183,-226r-108,0r65,85r-77,109r118,0r0,32r-174,0r0,-9r92,-128r-85,-112r0,-8r169,0r0,31","w":195},"\u03a4":{"d":"120,-226r0,226r-35,0r0,-226r-82,0r0,-31r203,0r0,31r-86,0","w":209},"\u03a5":{"d":"125,-115r0,115r-35,0r0,-115r-83,-142r36,0r64,112r64,-112r36,0","w":205},"\u03a6":{"d":"13,-130v0,-62,44,-111,107,-111r0,-27r35,0r0,27v62,2,106,45,106,108v0,63,-43,112,-106,113r0,27r-35,0r0,-27v-62,-3,-107,-46,-107,-110xm154,-47v69,3,92,-96,53,-143v-12,-15,-30,-23,-53,-24r0,167xm120,-214v-70,-4,-92,95,-53,142v13,15,30,24,53,25r0,-167","w":274},"\u03a7":{"d":"161,0r-64,-103r-59,103r-36,0r76,-134r-70,-124r35,1r55,97r61,-97r35,0r-80,124r84,133r-37,0","w":200},"\u03a8":{"d":"157,-90v39,-2,66,-30,66,-68r0,-99r34,0r0,98v1,59,-43,93,-100,97r0,63r-35,0r0,-63v-59,-2,-101,-37,-101,-95r0,-100r35,0v1,75,-15,163,66,167r0,-167r35,0r0,167","w":278},"\u03aa":{"d":"32,0r0,-257r36,0r0,257r-36,0xm72,-300v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm-11,-300v0,-11,9,-20,20,-20v11,0,19,9,19,20v0,11,-8,20,-19,20v-11,0,-20,-9,-20,-20","w":100},"\u03ab":{"d":"125,-115r0,115r-35,0r0,-115r-83,-142r36,0r64,112r64,-112r36,0xm129,-300v0,-11,9,-20,20,-20v11,0,19,9,19,20v0,11,-8,20,-19,20v-11,0,-20,-9,-20,-20xm45,-300v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":205},"\u03ac":{"d":"177,-144v0,43,-15,113,18,127r0,20v-30,1,-41,-5,-48,-25v-47,58,-144,9,-133,-71v-7,-75,79,-130,135,-79v8,-15,19,-21,44,-20r0,19v-12,5,-16,12,-16,29xm49,-94v0,59,62,94,95,47r0,-101v-39,-38,-95,-3,-95,54xm145,-284r-31,58r-28,0r19,-58r40,0","w":209},"\u03ad":{"d":"50,-53v4,42,67,33,92,9r16,26v-44,35,-141,32,-143,-32v0,-21,13,-37,40,-47v-19,-5,-34,-18,-35,-39v1,-60,79,-68,129,-41r-12,27v-31,-18,-80,-27,-83,12v-2,27,35,29,63,26r0,27v-29,-4,-70,1,-67,32xm131,-284r-32,58r-27,0r19,-58r40,0","w":168},"\u03ae":{"d":"112,-192v95,3,51,151,61,241r-33,8r0,-167v10,-63,-61,-65,-81,-29r0,139r-34,0r0,-188r23,0r10,23v13,-18,31,-27,54,-27xm147,-284r-32,58r-27,0r19,-58r40,0","w":197},"\u03af":{"d":"85,3v-90,4,-49,-115,-58,-191r33,0r0,133v0,19,9,29,25,30r0,28xm86,-284r-31,58r-28,0r19,-58r40,0","w":100},"\u03b0":{"d":"98,-24v67,0,34,-104,42,-165r33,0v-3,87,21,192,-75,192v-94,0,-72,-106,-74,-192r33,0v5,60,-20,166,41,165xm121,-284r-21,62r-20,0r10,-62r31,0xm128,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm27,-247v0,-11,8,-20,19,-20v11,0,21,8,20,20v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20","w":198},"\u03b1":{"d":"177,-144v0,43,-15,113,18,127r0,20v-30,1,-41,-5,-48,-25v-47,58,-144,9,-133,-71v-7,-75,79,-130,135,-79v8,-15,19,-21,44,-20r0,19v-12,5,-16,12,-16,29xm49,-94v0,59,62,94,95,47r0,-101v-39,-38,-95,-3,-95,54","w":209},"\u03b2":{"d":"169,-205v0,27,-21,49,-44,56v38,7,61,32,64,72v5,69,-88,105,-135,62v-7,9,-10,22,-29,18r0,-187v0,-47,26,-82,75,-82v39,0,70,22,69,61xm99,-240v-38,0,-44,38,-41,80v42,3,77,-6,77,-44v0,-22,-15,-37,-36,-36xm154,-76v0,-47,-42,-63,-96,-58r0,93v28,33,96,18,96,-35","w":203},"\u03b3":{"d":"192,-188r-75,181r0,81r-35,0r0,-78v-17,-60,-33,-117,-57,-150v-6,-5,-12,-7,-20,-7r0,-29v54,1,55,24,73,69v9,23,16,48,24,77r54,-144r36,0","w":195},"\u03b4":{"d":"13,-95v1,-57,33,-104,94,-93r-54,-68r0,-9r120,0r0,27r-70,0v24,28,80,82,80,144v0,56,-30,98,-85,98v-55,0,-86,-42,-85,-99xm98,-24v62,0,62,-105,26,-139v-48,-14,-76,21,-76,68v0,47,17,71,50,71","w":199},"\u03b5":{"d":"50,-53v4,42,67,33,92,9r16,26v-44,35,-141,32,-143,-32v0,-21,13,-37,40,-47v-19,-5,-34,-18,-35,-39v1,-60,79,-68,129,-41r-12,27v-31,-18,-80,-27,-83,12v-2,27,35,29,63,26r0,27v-29,-4,-70,1,-67,32","w":168},"\u03b6":{"d":"13,-72v0,-76,43,-109,95,-166r-70,0r0,-27r122,0r0,9v-55,63,-100,100,-110,180v-9,75,108,22,109,99v1,38,-41,60,-81,48r7,-27v26,13,55,-12,36,-34v-22,-16,-70,-4,-89,-29v-11,-14,-19,-31,-19,-53","w":159},"\u03b7":{"d":"112,-192v95,3,51,151,61,241r-33,8r0,-167v10,-63,-61,-65,-81,-29r0,139r-34,0r0,-188r23,0r10,23v13,-18,31,-27,54,-27","w":197},"\u03b8":{"d":"15,-129v1,-74,19,-137,84,-137v60,0,81,61,81,133v0,77,-18,137,-83,137v-61,0,-82,-61,-82,-133xm146,-150v-2,-42,-11,-88,-49,-89v-29,0,-44,29,-47,89r96,0xm146,-123r-96,0v2,67,18,100,49,100v31,0,46,-33,47,-100","w":195},"\u03b9":{"d":"85,3v-90,4,-49,-115,-58,-191r33,0r0,133v0,19,9,29,25,30r0,28","w":100},"\u03ba":{"d":"189,0r-44,0r-58,-85r-28,31r0,54r-34,0r0,-188r34,0r0,93r78,-93r42,0r-70,79","w":196},"\u03bb":{"d":"86,-192v-8,-34,-21,-59,-58,-40r-9,-28v52,-18,83,6,97,48r71,212r-37,0r-48,-153r-60,153r-37,0","w":190},"\u03bd":{"d":"176,-188r-83,192r-8,0r-81,-192r37,0r49,129r50,-129r36,0","w":179},"\u03be":{"d":"59,-202v0,39,39,46,83,43r0,28v-64,-13,-115,40,-81,91v26,22,102,5,102,63v0,38,-43,60,-83,48r6,-27v19,7,45,3,45,-19v0,-22,-23,-24,-45,-24v-42,-1,-73,-25,-72,-68v0,-40,25,-66,57,-77v-28,-5,-47,-24,-47,-55v-2,-63,77,-81,132,-57r-11,28v-29,-19,-86,-16,-86,26","w":165},"\u03bf":{"d":"13,-95v0,-54,34,-97,85,-97v55,0,85,39,85,97v0,59,-32,99,-85,99v-55,0,-85,-43,-85,-99xm98,-165v-35,0,-51,33,-50,70v0,47,16,71,50,71v35,0,51,-33,50,-71v0,-47,-17,-70,-50,-70","w":196},"\u03c1":{"d":"191,-94v0,76,-75,124,-135,83r0,85r-33,0v5,-109,-28,-266,82,-266v55,0,86,42,86,98xm105,-165v-50,0,-50,70,-48,127v41,32,99,6,99,-55v0,-40,-16,-72,-51,-72","w":205},"\u03c2":{"d":"34,-31v-45,-60,-10,-161,74,-161v20,0,37,5,52,16r-15,24v-45,-31,-97,2,-97,60v0,33,20,54,60,62v33,8,56,17,56,53v1,38,-41,60,-80,48r6,-27v27,14,56,-13,35,-36v-24,-14,-73,-15,-91,-39","w":165},"\u03c3":{"d":"13,-90v0,-58,38,-98,94,-98r90,0r0,28r-56,0v23,16,42,42,43,75v0,50,-34,89,-85,89v-53,0,-86,-39,-86,-94xm100,-24v33,0,49,-27,49,-61v0,-31,-22,-60,-42,-75v-40,0,-59,27,-59,68v0,38,16,68,52,68","w":205},"\u03c4":{"d":"131,-1v-40,12,-77,-2,-77,-47r0,-112r-47,0r0,-28r145,0r0,28r-64,0r0,107v-3,28,18,33,39,23","w":159},"\u03c5":{"d":"98,-24v68,0,36,-103,43,-164r33,0r0,106v0,57,-26,85,-77,85v-92,0,-71,-105,-73,-191r34,0v5,59,-20,164,40,164","w":198},"\u03c6":{"d":"110,3v-112,7,-124,-154,-42,-195r18,23v-39,24,-53,88,-22,125v11,12,28,19,47,21v3,-71,-19,-169,55,-169v46,0,74,45,74,95v0,58,-39,97,-96,100r0,71r-34,0r0,-71xm207,-92v1,-34,-14,-74,-41,-74v-15,0,-23,13,-23,38r0,105v39,-3,64,-28,64,-69","w":254},"\u03c7":{"d":"180,0r-42,0r-48,-72r-47,72r-39,0r69,-97r-64,-91r40,0r42,66r44,-66r38,0r-66,90","w":183},"\u03c8":{"d":"147,-23v72,-2,54,-93,56,-165r33,0r0,94v0,59,-33,93,-89,97r0,71r-34,0r0,-71v-60,-4,-90,-36,-90,-96r0,-95r34,0v3,70,-19,160,57,165r0,-165r33,0r0,165","w":259},"\u03c9":{"d":"154,-136v-3,41,-12,112,36,112v23,0,35,-20,35,-60v0,-35,-13,-64,-41,-88r23,-21v35,29,53,65,53,108v0,80,-90,124,-123,54v-34,68,-123,27,-123,-52v0,-44,17,-81,53,-110r23,20v-23,19,-41,50,-42,88v0,34,11,60,40,61v44,1,33,-71,31,-112r35,0","w":273},"\u03ca":{"d":"85,3v-90,4,-49,-115,-58,-191r33,0r0,133v0,19,9,29,25,30r0,28xm66,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm-17,-247v0,-11,9,-20,20,-20v11,0,19,9,19,20v0,11,-8,20,-19,20v-11,0,-20,-9,-20,-20","w":100},"\u03cb":{"d":"98,-24v67,0,34,-104,42,-165r33,0v-3,87,21,192,-75,192v-94,0,-72,-106,-74,-192r33,0v5,60,-20,166,41,165xm121,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v1,12,-9,20,-20,20v-11,0,-19,-9,-19,-20xm37,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":198},"\u03cc":{"d":"13,-95v0,-54,34,-97,85,-97v55,0,85,39,85,97v0,59,-32,99,-85,99v-55,0,-85,-43,-85,-99xm98,-165v-35,0,-51,33,-50,70v0,47,16,71,50,71v35,0,51,-33,50,-71v0,-47,-17,-70,-50,-70xm140,-284r-31,58r-28,0r21,-58r38,0","w":196},"\u03cd":{"d":"98,-24v68,0,36,-103,43,-164r33,0r0,106v0,57,-26,85,-77,85v-92,0,-71,-105,-73,-191r34,0v5,59,-20,164,40,164xm142,-284r-31,58r-29,0r18,-58r42,0","w":198},"\u03ce":{"d":"154,-136v-3,41,-12,112,36,112v23,0,35,-20,35,-60v0,-35,-13,-64,-41,-88r23,-21v30,24,48,60,53,108v8,80,-90,124,-123,54v-34,68,-123,27,-123,-52v0,-44,17,-81,53,-110r23,20v-23,19,-41,50,-42,88v0,34,11,60,40,61v44,1,33,-71,31,-112r35,0xm181,-284r-31,58r-28,0r20,-58r39,0","w":273},"\u0401":{"d":"62,-226r0,71r85,0r0,30r-85,0r0,93r116,0r0,32r-152,0r0,-257r154,0r0,31r-118,0xm121,-299v0,-12,9,-19,19,-20v10,-1,21,9,20,20v0,11,-9,20,-20,20v-11,1,-19,-10,-19,-20xm50,-299v-1,-10,10,-21,20,-20v11,0,20,9,20,20v0,10,-9,20,-20,20v-11,0,-20,-10,-20,-20","w":195},"\u0402":{"d":"116,-154v69,-15,137,7,134,77v-2,53,-38,87,-94,77r0,-29v38,9,57,-12,57,-51v0,-49,-51,-56,-97,-45r0,125r-35,0r0,-226r-71,0r0,-31r190,0r0,31r-84,0r0,72","w":262},"\u0403":{"d":"176,-226r-114,0r0,226r-36,0r0,-257r150,0r0,31xm153,-337r-40,58r-24,0r29,-58r35,0","w":187},"\u0404":{"d":"50,-122v1,52,27,95,76,96v24,0,42,-10,56,-27r19,27v-20,20,-47,30,-79,30v-71,1,-108,-59,-108,-132v0,-72,43,-135,114,-134v23,0,44,5,63,14r-12,30v-33,-19,-79,-20,-103,8v-12,14,-20,34,-24,60r95,0r0,28r-97,0","w":210},"\u0405":{"d":"129,-129v58,42,22,133,-55,133v-23,0,-43,-5,-59,-16r13,-32v27,23,101,25,97,-23v-6,-69,-110,-43,-110,-128v0,-65,90,-83,132,-53r-11,31v-24,-20,-87,-23,-86,22v1,45,53,47,79,66","w":174},"\u0406":{"d":"32,0r0,-257r36,0r0,257r-36,0","w":100},"\u0407":{"d":"32,0r0,-257r36,0r0,257r-36,0xm65,-299v0,-10,9,-21,20,-20v10,0,21,9,20,20v0,10,-9,21,-20,20v-10,0,-21,-9,-20,-20xm-5,-299v0,-10,9,-21,20,-20v10,-1,21,10,20,20v1,11,-10,20,-20,20v-10,0,-21,-9,-20,-20","w":100},"\u0408":{"d":"144,-257v-9,103,38,261,-77,261v-34,0,-58,-23,-59,-56r30,0v3,16,13,24,29,24v43,-2,43,-15,43,-67r0,-162r34,0","w":168},"\u0409":{"d":"335,-82v0,77,-75,88,-159,82r0,-226r-48,0v-19,87,-30,183,-87,221v-9,6,-22,7,-36,7r0,-32v30,-3,35,-15,49,-45v25,-52,33,-109,49,-182r108,0r0,97v69,-10,124,14,124,78xm300,-82v0,-45,-43,-57,-90,-49r0,101v49,8,90,-6,90,-52","w":349},"\u040a":{"d":"314,-82v0,77,-75,88,-159,82r0,-125r-94,0r0,125r-35,0r0,-257r35,0r0,102r94,0r0,-102r35,0r0,97v69,-10,124,14,124,78xm279,-82v0,-45,-42,-57,-90,-49r0,101v49,8,90,-6,90,-52","w":328},"\u040b":{"d":"116,-154v67,-15,129,8,129,74r0,80r-36,0v-1,-59,15,-129,-52,-129v-12,0,-26,1,-41,4r0,125r-35,0r0,-226r-71,0r0,-31r189,0r0,31r-83,0r0,72","w":267},"\u040c":{"d":"204,1v-92,15,-31,-133,-142,-122r0,121r-36,0r0,-257r36,0r0,106v46,1,75,-20,81,-59v5,-34,18,-54,57,-48r0,30v-19,-1,-20,6,-24,24v-7,34,-30,59,-61,68v45,11,59,60,72,102v4,5,9,4,17,4r0,31xm159,-337r-39,58r-25,0r30,-58r34,0","w":220},"\u040e":{"d":"205,-257v-24,93,-59,186,-112,234v-19,18,-43,25,-70,25r0,-34v28,0,51,-13,68,-40r-89,-185r41,0r69,157v24,-49,42,-101,55,-157r38,0xm171,-332v-8,36,-29,54,-63,54v-34,0,-55,-18,-63,-54r30,-7v3,48,65,48,68,1","w":207},"\u040f":{"d":"202,0r-71,0r0,74r-33,0r0,-74r-72,0r0,-257r36,0r0,226r105,0r0,-226r35,0r0,257","w":228},"\u0410":{"d":"173,0r-17,-54r-96,0r-19,54r-40,0r105,-261r9,0r97,261r-39,0xm109,-194r-40,114r76,0","w":213},"\u0411":{"d":"190,-80v2,79,-80,85,-164,80r0,-257r146,0r0,30r-110,0r0,71v71,-7,127,11,128,76xm62,-30v54,8,89,-6,91,-51v2,-43,-45,-53,-91,-46r0,97","w":204},"\u0412":{"d":"190,-75v1,75,-83,80,-164,75r0,-257v77,-7,145,-9,148,61v1,24,-23,46,-43,51v39,9,59,32,59,70xm62,-229r0,73v37,5,82,-2,77,-39v3,-35,-39,-40,-77,-34xm153,-80v0,-48,-34,-53,-91,-48r0,98v51,6,91,0,91,-50","w":204},"\u0413":{"d":"176,-226r-114,0r0,226r-36,0r0,-257r150,0r0,31","w":187},"\u0414":{"d":"20,-30v51,-68,69,-126,90,-227r103,0r0,227r28,0r0,104r-32,0r0,-74r-172,0r0,74r-32,0r0,-104r15,0xm180,-30r0,-198r-46,0v-16,82,-41,148,-77,198r123,0","w":248},"\u0415":{"d":"62,-226r0,71r85,0r0,30r-85,0r0,93r116,0r0,32r-152,0r0,-257r154,0r0,31r-118,0","w":195},"\u0416":{"d":"306,1v-88,16,-30,-129,-127,-123r0,122r-35,0r0,-122v-68,-6,-63,70,-86,112v-6,12,-27,14,-43,11r0,-31v20,3,22,-10,25,-27v7,-42,24,-63,58,-78v-38,-7,-51,-47,-60,-87v-1,-6,-10,-6,-19,-6r0,-30v84,-16,29,115,125,108r0,-107r35,0r0,107v42,0,61,-22,67,-60v5,-34,19,-53,57,-48r0,30v-18,-1,-21,5,-24,24v-6,32,-27,59,-56,68v41,15,54,52,64,99v2,8,10,7,19,7r0,31","w":321},"\u0417":{"d":"166,-195v-1,27,-22,50,-45,56v31,8,50,28,53,64v6,79,-109,97,-165,62r13,-32v37,30,118,27,117,-29v-1,-42,-40,-56,-86,-50r0,-29v43,3,81,-5,79,-43v-3,-47,-67,-44,-102,-21r-11,-29v54,-30,150,-21,147,51"},"\u0418":{"d":"216,0r-36,0r0,-185r-144,189r-10,0r0,-261r36,0r0,184r144,-188r10,0r0,261","w":241},"\u0419":{"d":"216,0r-36,0r0,-185r-144,189r-10,0r0,-261r36,0r0,184r144,-188r10,0r0,261xm191,-332v-8,36,-29,54,-63,54v-34,0,-55,-18,-63,-54r30,-7v3,48,64,48,67,1","w":241},"\u041a":{"d":"204,1v-92,15,-31,-133,-142,-122r0,121r-36,0r0,-257r36,0r0,106v46,1,75,-20,81,-59v5,-34,18,-54,57,-48r0,30v-19,-1,-20,6,-24,24v-7,34,-30,59,-61,68v45,11,59,60,72,102v4,5,9,4,17,4r0,31","w":220},"\u041b":{"d":"216,0r-36,0r0,-226r-57,0v-13,91,-19,192,-85,224v-9,4,-20,4,-33,4r0,-33v42,-3,45,-28,60,-67v18,-47,24,-99,32,-159r119,0r0,257","w":241},"\u041c":{"d":"225,0r-31,-166r-57,170r-9,0r-56,-170r-30,166r-33,0r50,-257r15,0r60,187r59,-187r15,0r51,257r-34,0","w":267},"\u041d":{"d":"174,0r0,-125r-112,0r0,125r-36,0r0,-257r36,0r0,102r112,0r0,-102r35,0r0,257r-35,0","w":235},"\u041e":{"d":"118,4v-70,0,-104,-61,-104,-135v0,-69,37,-132,104,-131v75,1,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-48,0,-67,43,-67,99v0,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99","w":242},"\u041f":{"d":"202,0r-35,0r0,-226r-105,0r0,226r-36,0r0,-257r176,0r0,257","w":228},"\u0420":{"d":"62,-99r0,99r-36,0r0,-257v86,-9,161,7,161,73v0,67,-49,92,-125,85xm62,-226r0,95v46,7,93,-7,88,-49v4,-37,-39,-52,-88,-46","w":200},"\u0421":{"d":"14,-128v0,-71,42,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-51,0,-75,52,-75,104v0,51,26,99,75,99v24,0,43,-9,56,-26r19,27v-21,20,-47,30,-79,30v-71,1,-108,-59,-108,-132","w":211},"\u0422":{"d":"127,-226r0,226r-35,0r0,-226r-82,0r0,-31r203,0r0,31r-86,0","w":222},"\u0423":{"d":"205,-257v-24,93,-59,186,-112,234v-19,18,-43,25,-70,25r0,-34v28,0,51,-13,68,-40r-89,-185r41,0r69,157v24,-49,42,-101,55,-157r38,0","w":207},"\u0424":{"d":"13,-129v0,-58,43,-103,102,-104r0,-30r35,0r0,30v58,0,103,42,103,100v0,59,-44,104,-103,105r0,32r-35,0r0,-32v-58,0,-103,-44,-102,-101xm150,-55v65,3,87,-85,50,-129v-12,-14,-29,-21,-50,-22r0,151xm116,-206v-65,-4,-89,85,-51,129v12,14,30,21,51,22r0,-151","w":265},"\u0425":{"d":"162,0r-64,-103r-59,103r-35,0r76,-134r-70,-124r35,1r54,97r61,-97r35,0r-80,124r85,133r-38,0","w":203},"\u0426":{"d":"226,74r-32,0r0,-74r-168,0r0,-257r36,0r0,226r101,0r0,-226r35,0r0,226r28,0r0,105","w":234},"\u0427":{"d":"57,-257v0,60,-11,134,52,130v15,0,30,-2,45,-6r0,-124r35,0r0,257r-35,0r0,-104v-69,19,-133,-4,-133,-76r0,-77r36,0","w":214},"\u0428":{"d":"295,0r-269,0r0,-257r34,0r0,227r84,0r0,-227r34,0r0,227r84,0r0,-227r33,0r0,257","w":321},"\u0429":{"d":"323,74r-31,0r0,-74r-266,0r0,-257r34,0r0,227r84,0r0,-227r34,0r0,227r84,0r0,-227r33,0r0,227r28,0r0,104","w":331},"\u042a":{"d":"252,-82v0,50,-40,82,-92,82r-72,0r0,-226r-78,0r0,-31r113,0r0,98v70,-10,129,11,129,77xm215,-82v1,-46,-45,-56,-92,-49r0,101v55,8,91,-5,92,-52","w":266},"\u042b":{"d":"255,0r-34,0r0,-257r34,0r0,257xm188,-82v0,51,-39,82,-91,82r-71,0r0,-257r35,0r0,97v70,-10,127,13,127,78xm153,-82v0,-46,-46,-57,-93,-49r0,101v50,8,93,-5,93,-52","w":281},"\u042c":{"d":"193,-82v0,50,-40,82,-92,82r-75,0r0,-257r36,0r0,98v71,-10,131,10,131,77xm156,-82v0,-46,-46,-57,-94,-49r0,101v49,8,94,-4,94,-52","w":207},"\u042d":{"d":"160,-150v0,-67,-72,-106,-127,-65r-14,-30v20,-11,43,-17,69,-17v71,-1,109,58,109,132v0,74,-40,135,-111,134v-30,0,-57,-8,-77,-24r16,-31v31,33,87,34,114,-1v14,-17,22,-40,23,-70r-98,0r0,-28r96,0","w":211},"\u042e":{"d":"200,4v-67,0,-97,-58,-98,-129r-42,0r0,125r-34,0r0,-257r34,0r0,102r43,0v7,-59,39,-106,98,-107v71,-1,104,57,103,131v-2,76,-30,135,-104,135xm200,-232v-89,0,-84,207,1,206v51,-1,67,-47,67,-105v0,-58,-17,-101,-68,-101","w":318},"\u042f":{"d":"26,-184v0,-75,80,-83,163,-73r0,257r-35,0r0,-112v-56,-3,-81,16,-88,67v-5,36,-17,50,-56,46r0,-31v18,1,18,-7,22,-24v8,-35,24,-58,52,-68v-38,-9,-58,-24,-58,-62xm154,-227v-42,-8,-92,-3,-92,39v0,40,42,52,92,48r0,-87","w":215},"\u0430":{"d":"173,3v-27,0,-39,-7,-45,-25v-29,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-63,-55,-89,-29r-14,-28v12,-9,38,-19,59,-19v53,1,77,23,77,78v0,36,-9,88,15,101r0,16xm125,-92v-40,-13,-79,7,-79,40v0,42,62,34,79,5r0,-45","w":184},"\u0431":{"d":"101,4v-112,5,-109,-202,-35,-242v27,-15,72,-22,107,-31r8,31v-67,16,-73,13,-110,31v-20,15,-27,37,-31,71v14,-24,36,-41,68,-42v49,-1,79,37,79,87v0,55,-33,93,-86,95xm49,-88v0,35,21,64,54,64v34,0,48,-28,48,-64v0,-37,-13,-62,-48,-62v-32,-1,-54,29,-54,62","w":198},"\u0432":{"d":"164,-139v0,18,-13,33,-28,38v65,25,34,101,-36,101r-76,0r0,-188v63,-2,140,-14,140,49xm131,-139v0,-34,-52,-26,-76,-24r0,51v2,0,16,1,41,1v24,0,35,-9,35,-28xm139,-56v3,-37,-54,-32,-84,-30r0,59v34,4,88,6,84,-29","w":185},"\u0433":{"d":"145,-160r-88,0r0,160r-33,0r0,-188r121,0r0,28","w":155},"\u0434":{"d":"22,-27v31,-35,48,-95,45,-161r111,0r0,161r22,0r0,89r-30,0r0,-62r-133,0r0,62r-30,0r0,-89r15,0xm95,-162v0,52,-17,104,-41,135r92,0r0,-135r-51,0","w":208},"\u0435":{"d":"100,-192v57,-2,95,43,82,101r-136,0v-6,62,68,85,108,50r13,27v-18,13,-37,18,-68,18v-52,1,-87,-42,-87,-96v0,-55,38,-99,88,-100xm152,-115v3,-44,-59,-65,-88,-35v-10,10,-16,22,-17,35r105,0","w":196},"\u0436":{"d":"251,1v-26,4,-45,-6,-48,-32v-5,-37,-17,-53,-54,-55r0,86r-31,0r0,-86v-39,1,-51,18,-56,55v-3,26,-21,36,-48,32r0,-29v9,2,17,0,19,-10v5,-33,22,-53,47,-61v-26,-7,-41,-22,-45,-51v-2,-11,-11,-12,-18,-10r0,-29v26,-4,42,6,47,31v6,32,18,45,54,45r0,-75r31,0r0,75v35,0,48,-14,53,-45v5,-26,21,-35,46,-31r0,29v-7,-2,-18,-1,-18,10v0,27,-19,44,-43,51v28,10,41,28,46,62v2,10,9,11,18,9r0,29","w":265},"\u0437":{"d":"17,-177v49,-27,127,-20,129,39v0,19,-10,33,-30,40v68,27,31,102,-38,102v-25,0,-48,-8,-69,-22r17,-26v15,14,33,20,54,20v19,0,37,-9,37,-28v0,-29,-31,-38,-63,-33r0,-27v21,3,61,0,58,-25v-4,-39,-55,-31,-82,-13","w":163},"\u0438":{"d":"182,0r-33,0r0,-129r-118,134r-7,0r0,-193r33,0r0,129r118,-134r7,0r0,193","w":205},"\u0439":{"d":"182,0r-33,0r0,-129r-118,134r-7,0r0,-193r33,0r0,129r118,-134r7,0r0,193xm169,-279v-8,36,-29,54,-63,54v-34,0,-55,-18,-63,-54r30,-7v3,49,65,47,68,0","w":205},"\u043a":{"d":"172,1v-27,4,-47,-6,-50,-32v-5,-37,-23,-56,-65,-55r0,86r-33,0r0,-188r33,0r0,75v38,1,57,-12,63,-44v4,-26,22,-36,49,-32r0,29v-9,-2,-17,-1,-19,10v-4,26,-21,43,-47,51v27,9,44,30,50,62v1,11,12,11,19,9r0,29","w":185},"\u043b":{"d":"7,-28v50,-2,59,-103,58,-160r115,0r0,188r-33,0r0,-162r-51,0v-7,77,-9,163,-89,164r0,-30","w":202},"\u043c":{"d":"203,0r-20,-113r-57,116r-9,0r-56,-115r-20,112r-32,0r36,-192r9,0r70,141r69,-141r8,0r36,192r-34,0","w":245},"\u043d":{"d":"178,0r-34,0r0,-85r-87,0r0,85r-33,0r0,-188r33,0r0,75r87,0r0,-75r34,0r0,188","w":201},"\u043e":{"d":"12,-95v0,-55,34,-97,85,-97v55,0,85,39,85,97v0,59,-30,99,-85,99v-55,0,-85,-42,-85,-99xm97,-165v-35,0,-51,33,-51,70v0,47,17,71,51,71v35,0,51,-33,50,-71v0,-47,-17,-70,-50,-70","w":193},"\u043f":{"d":"173,0r-34,0r0,-160r-82,0r0,160r-33,0r0,-188r149,0r0,188","w":196},"\u0440":{"d":"188,-94v7,74,-71,123,-131,84r0,84r-33,0r0,-262r33,0r0,15v55,-48,140,0,131,79xm153,-95v8,-62,-59,-87,-96,-53r0,110v38,31,103,6,96,-57","w":200},"\u0441":{"d":"12,-92v-9,-84,91,-127,154,-81r-16,24v-41,-33,-111,-5,-103,57v-5,62,64,89,107,50r13,28v-62,42,-164,6,-155,-78","w":178},"\u0442":{"d":"152,-160r-54,0r0,160r-33,0r0,-160r-54,0r0,-28r141,0r0,28","w":163},"\u0443":{"d":"23,43v37,2,59,-28,45,-64r-65,-168r34,0r55,145r50,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30","w":178},"\u0444":{"d":"13,-93v0,-66,50,-120,111,-90r0,-82r33,0r0,82v59,-29,109,21,109,89v0,68,-48,117,-109,90r0,78r-33,0r0,-78v-62,28,-111,-23,-111,-89xm233,-95v0,-49,-30,-83,-76,-65r0,131v44,19,76,-8,76,-66xm46,-95v0,49,31,85,78,67r0,-131v-46,-20,-78,14,-78,64","w":279},"\u0445":{"d":"180,0r-42,0r-48,-72r-47,72r-39,0r69,-97r-64,-91r40,0r42,66r44,-66r38,0r-66,90","w":183},"\u0446":{"d":"190,61r-31,0r0,-61r-135,0r0,-188r33,0r0,160r77,0r0,-160r34,0r0,160r22,0r0,89","w":198},"\u0447":{"d":"53,-188v-1,46,-6,96,41,93v13,0,27,-2,40,-5r0,-88r33,0r0,188r-33,0r0,-74v-56,17,-120,1,-115,-63r0,-51r34,0","w":191},"\u0448":{"d":"249,0r-225,0r0,-188r31,0r0,161r66,0r0,-161r31,0r0,161r65,0r0,-161r32,0r0,188","w":272},"\u0449":{"d":"269,62r-29,0r0,-62r-216,0r0,-188r31,0r0,161r65,0r0,-161r31,0r0,161r65,0r0,-161r31,0r0,161r22,0r0,89","w":277},"\u044a":{"d":"207,-59v0,62,-74,62,-142,59r0,-161r-55,0r0,-27r88,0r0,69v60,-8,109,4,109,60xm173,-60v-3,-36,-36,-39,-75,-32r0,65v30,3,78,4,75,-33","w":219},"\u044b":{"d":"223,0r-33,0r0,-188r33,0r0,188xm163,-59v-3,61,-71,63,-139,59r0,-188r33,0r0,69v55,-8,109,5,106,60xm130,-60v-1,-35,-35,-39,-73,-33r0,66v32,4,74,1,73,-33","w":246},"\u044c":{"d":"170,-59v0,63,-77,62,-146,59r0,-188r33,0r0,70v60,-10,113,1,113,59xm57,-27v29,3,79,5,79,-33v0,-37,-40,-39,-79,-32r0,65","w":182},"\u044d":{"d":"133,-111v-3,-51,-65,-70,-104,-38r-14,-25v64,-44,160,-4,152,79v9,86,-95,127,-156,78r16,-25v40,39,112,13,107,-43r-77,0r0,-26r76,0","w":178},"\u044e":{"d":"169,4v-49,0,-76,-37,-78,-89r-35,0r0,85r-32,0r0,-188r32,0r0,76r35,0v5,-45,32,-79,78,-80v52,0,79,41,79,97v0,54,-28,99,-79,99xm123,-95v0,42,11,72,47,72v33,0,45,-34,45,-71v0,-47,-16,-72,-46,-72v-34,0,-46,34,-46,71","w":259},"\u044f":{"d":"25,-133v1,-63,75,-60,140,-55r0,188r-32,0r0,-77v-46,-2,-68,9,-74,49v-3,24,-21,33,-46,29r0,-29v8,2,15,0,17,-10v4,-24,17,-39,40,-48v-25,-3,-44,-22,-45,-47xm58,-134v0,33,41,34,75,34r0,-63v-35,-5,-75,-3,-75,29"},"\u0451":{"d":"100,-192v57,-2,95,43,82,101r-136,0v-6,62,68,85,108,50r13,27v-18,13,-37,18,-68,18v-52,1,-87,-42,-87,-96v0,-55,38,-99,88,-100xm152,-115v3,-44,-59,-65,-88,-35v-10,10,-16,22,-17,35r105,0xm120,-239v0,-10,8,-21,19,-20v10,0,21,9,20,20v0,11,-9,20,-20,20v-11,1,-19,-10,-19,-20xm49,-239v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,10,-9,20,-20,20v-11,0,-20,-10,-20,-20","w":196},"\u0452":{"d":"59,-158v36,-47,116,-21,116,48r0,110v0,50,-29,75,-85,75r0,-30v33,-1,54,-9,51,-45v-4,-57,23,-154,-39,-154v-16,0,-30,9,-43,25r0,129r-34,0r0,-209r-26,0r0,-25r26,0r0,-31r34,0r0,31r65,0r0,25r-65,0r0,51","w":197},"\u0453":{"d":"145,-160r-88,0r0,160r-33,0r0,-188r121,0r0,28xm136,-284r-39,58r-25,0r30,-58r34,0","w":155},"\u0454":{"d":"45,-84v-1,58,69,78,110,44r12,26v-17,12,-39,18,-67,18v-54,1,-88,-42,-88,-96v0,-83,91,-128,154,-81r-17,24v-38,-35,-103,-7,-103,39r76,0r0,26r-77,0","w":178},"\u0455":{"d":"135,-50v0,59,-80,66,-123,39r12,-32v19,12,34,19,45,19v21,0,31,-9,31,-27v0,-45,-90,-34,-87,-92v2,-53,67,-60,113,-36r-9,31v-13,-11,-27,-16,-40,-16v-12,0,-29,7,-28,20v6,47,86,32,86,94","w":147},"\u0456":{"d":"31,-239v0,-12,11,-24,23,-23v11,1,23,10,23,23v0,13,-11,23,-23,23v-14,0,-23,-11,-23,-23xm41,0r0,-160r-26,0r0,-28r59,0r0,188r-33,0","w":101},"\u0457":{"d":"65,-239v0,-10,9,-21,19,-20v10,0,21,9,20,20v0,11,-9,20,-20,20v-11,1,-19,-10,-19,-20xm-6,-239v0,-10,9,-21,20,-20v11,0,20,9,20,20v0,10,-9,20,-20,20v-11,0,-20,-10,-20,-20xm74,0r-33,0r0,-160r-26,0r0,-28r59,0r0,188","w":101},"\u0458":{"d":"39,-239v0,-12,10,-24,24,-23v11,1,23,10,23,23v0,13,-10,23,-23,23v-15,0,-24,-11,-24,-23xm-10,44v42,0,59,-8,60,-45r0,-159r-37,0r0,-28r70,0r0,187v1,57,-36,74,-93,75r0,-30","w":109},"\u0459":{"d":"7,-28v57,-10,55,-94,58,-160r114,0r0,69v55,-8,107,4,105,60v-3,62,-71,62,-138,59r0,-162r-51,0v-6,80,-10,160,-88,164r0,-30xm251,-60v-2,-35,-34,-39,-72,-33r0,66v32,4,74,1,72,-33","w":296},"\u045a":{"d":"272,-59v-3,61,-71,63,-139,59r0,-85r-76,0r0,85r-33,0r0,-188r33,0r0,75r76,0r0,-75r33,0r0,69v55,-8,108,5,106,60xm239,-60v-2,-35,-35,-39,-73,-33r0,66v32,4,75,2,73,-33","w":284},"\u045b":{"d":"59,-158v36,-47,116,-21,116,48r0,110r-34,0v-6,-57,23,-154,-39,-154v-16,0,-30,9,-43,25r0,129r-34,0r0,-209r-26,0r0,-25r26,0r0,-31r34,0r0,31r65,0r0,25r-65,0r0,51","w":197},"\u045c":{"d":"172,1v-27,4,-47,-6,-50,-32v-5,-37,-23,-56,-65,-55r0,86r-33,0r0,-188r33,0r0,75v38,1,57,-12,63,-44v4,-26,22,-36,49,-32r0,29v-9,-2,-17,-1,-19,10v-4,26,-21,43,-47,51v27,9,44,30,50,62v1,11,12,11,19,9r0,29xm144,-284r-40,58r-25,0r30,-58r35,0","w":185},"\u045e":{"d":"22,44v37,2,59,-27,45,-64r-65,-168r34,0r55,145r51,-145r33,0r-79,220v-7,24,-42,43,-74,42r0,-30xm157,-280v-8,36,-29,54,-63,54v-34,0,-55,-18,-63,-54r29,-7v4,48,65,50,68,1","w":178},"\u045f":{"d":"173,0r-60,0r0,62r-30,0r0,-62r-59,0r0,-188r33,0r0,160r82,0r0,-160r34,0r0,188","w":196},"\u0490":{"d":"176,-226r-114,0r0,226r-36,0r0,-257r121,0r0,-56r29,0r0,87","w":187},"\u0491":{"d":"145,-160r-88,0r0,160r-33,0r0,-188r93,0r0,-47r28,0r0,75","w":155},"\u0100":{"d":"173,0r-18,-54r-96,0r-19,54r-39,0r104,-261r10,0r97,261r-39,0xm108,-194r-40,114r77,0xm174,-304r0,25r-129,0r0,-25r129,0","w":212},"\u0101":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm151,-251r0,25r-129,0r0,-25r129,0","w":189},"\u0108":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132xm154,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":215},"\u0109":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78xm131,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":178},"\u010a":{"d":"14,-128v0,-71,43,-135,111,-134v28,0,50,5,66,14r-12,30v-11,-8,-29,-12,-53,-12v-50,1,-75,48,-75,104v0,53,28,98,75,99v24,0,43,-9,56,-26r19,27v-20,20,-46,30,-78,30v-71,0,-109,-57,-109,-132xm101,-300v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":215},"\u010b":{"d":"11,-92v0,-83,90,-127,155,-81r-17,24v-40,-33,-111,-5,-102,57v-6,62,63,86,107,50r13,28v-63,43,-156,6,-156,-78xm80,-247v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":178},"\u0112":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm168,-304r0,25r-129,0r0,-25r129,0","w":192},"\u0113":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm164,-251r0,25r-129,0r0,-25r129,0","w":196},"\u0114":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm101,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":192},"\u0115":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm99,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":196},"\u0116":{"d":"62,-226r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-152,0r0,-258r154,0r0,32r-118,0xm82,-300v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":192},"\u0117":{"d":"100,-192v58,0,96,43,82,101r-135,0v-7,61,66,84,107,50r14,24v-13,12,-43,21,-69,21v-51,-1,-88,-43,-88,-96v0,-54,37,-100,89,-100xm152,-115v3,-45,-58,-65,-88,-34v-9,10,-16,20,-17,34r105,0xm77,-247v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":196},"\u011c":{"d":"14,-128v0,-104,109,-172,191,-112r-15,29v-65,-50,-139,4,-139,85v0,76,74,127,131,82r0,-60r-36,0r0,-30r71,0r0,112v-16,15,-57,26,-88,26v-73,1,-115,-56,-115,-132xm157,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":243},"\u011d":{"d":"170,16v0,66,-110,71,-153,36r18,-27v19,13,38,19,54,19v24,0,49,-7,49,-27v0,-52,-120,14,-117,-47v0,-15,18,-25,33,-28v-66,-24,-43,-134,31,-134v19,0,34,4,44,12r17,-20r21,20r-20,15v33,44,-1,116,-51,114v-18,3,-45,0,-49,15v6,16,48,2,64,2v36,0,59,16,59,50xm126,-123v0,-23,-16,-42,-38,-42v-24,-1,-40,19,-40,42v0,25,15,47,40,46v24,-1,38,-20,38,-46xm116,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":180},"\u0120":{"d":"14,-128v0,-104,109,-172,191,-112r-15,29v-65,-50,-139,4,-139,85v0,76,74,127,131,82r0,-60r-36,0r0,-30r71,0r0,112v-16,15,-57,26,-88,26v-73,1,-115,-56,-115,-132xm110,-300v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":243},"\u0121":{"d":"170,16v0,66,-110,71,-153,36r18,-27v19,13,38,19,54,19v24,0,49,-7,49,-27v0,-52,-120,14,-117,-47v0,-15,18,-25,33,-28v-66,-24,-43,-134,31,-134v19,0,34,4,44,12r17,-20r21,20r-20,15v33,44,-1,116,-51,114v-18,3,-45,0,-49,15v6,16,48,2,64,2v36,0,59,16,59,50xm126,-123v0,-23,-16,-42,-38,-42v-24,-1,-40,19,-40,42v0,25,15,47,40,46v24,-1,38,-20,38,-46xm64,-247v0,-11,10,-20,21,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-12,0,-20,-10,-21,-21","w":180},"\u0122":{"d":"14,-128v0,-104,109,-172,191,-112r-15,29v-65,-50,-139,4,-139,85v0,76,74,127,131,82r0,-60r-36,0r0,-30r71,0r0,112v-16,15,-57,26,-88,26v-73,1,-115,-56,-115,-132xm118,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":243},"\u0123":{"d":"170,16v0,66,-110,71,-153,36r18,-27v19,13,38,19,54,19v24,0,49,-7,49,-27v0,-52,-120,14,-117,-47v0,-15,18,-25,33,-28v-66,-24,-43,-134,31,-134v19,0,34,4,44,12r17,-20r21,20r-20,15v33,44,-1,116,-51,114v-18,3,-45,0,-49,15v6,16,48,2,64,2v36,0,59,16,59,50xm126,-123v0,-23,-16,-42,-38,-42v-24,-1,-40,19,-40,42v0,25,15,47,40,46v24,-1,38,-20,38,-46xm89,-271v-1,11,15,17,15,28v0,11,-7,17,-19,17v-13,0,-19,-8,-19,-25v0,-20,9,-37,27,-51r10,10v-9,10,-13,11,-14,21","w":180},"\u0124":{"d":"174,0r0,-124r-112,0r0,124r-36,0r0,-258r36,0r0,104r112,0r0,-104r35,0r0,258r-35,0xm146,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":235},"\u0125":{"d":"109,-192v84,-1,61,111,64,192r-33,0v-7,-61,24,-161,-40,-164v-17,-1,-36,14,-43,24r0,140r-33,0r0,-265r33,0r0,97v8,-12,31,-24,52,-24xm126,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":196},"\u0126":{"d":"241,-194r-26,0r0,194r-35,0r0,-122r-115,0r0,122r-35,0r0,-194r-26,0r0,-24r26,0r0,-40r35,0r0,40r115,0r0,-40r35,0r0,40r26,0r0,24xm180,-152r0,-42r-115,0r0,42r115,0","w":245},"\u0127":{"d":"59,-158v34,-46,116,-23,116,48r0,110r-34,0v-6,-57,23,-154,-39,-154v-19,0,-34,12,-43,25r0,129r-34,0r0,-209r-26,0r0,-25r26,0r0,-31r34,0r0,31r65,0r0,25r-65,0r0,51","w":197},"\u0128":{"d":"33,0r0,-258r35,0r0,258r-35,0xm26,-315v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":100},"\u0129":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm28,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":102},"\u012a":{"d":"33,0r0,-258r35,0r0,258r-35,0xm114,-304r0,25r-129,0r0,-25r129,0","w":100},"\u012b":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm116,-251r0,25r-129,0r0,-25r129,0","w":102},"\u012c":{"d":"33,0r0,-258r35,0r0,258r-35,0xm48,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":100},"\u012d":{"d":"40,0r0,-160r-26,0r0,-28r60,0r0,188r-34,0xm49,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":102},"\u012e":{"d":"68,0v-20,4,-26,41,2,40v6,0,13,-2,19,-6r12,25v-48,27,-103,-23,-68,-67r0,-250r35,0r0,258","w":100},"\u012f":{"d":"37,-239v0,-25,42,-27,42,0v1,12,-10,21,-21,21v-12,0,-20,-10,-21,-21xm73,0v-21,4,-25,41,3,40v6,0,12,-2,18,-6r12,25v-35,17,-79,1,-79,-37v0,-12,5,-23,13,-32r0,-150r-26,0r0,-28r59,0r0,188","w":102},"\u0132":{"d":"33,0r0,-258r35,0r0,258r-35,0xm235,-258v-10,103,38,262,-77,262v-34,0,-58,-22,-59,-56r30,0v3,16,12,24,28,24v43,-2,43,-15,43,-67r0,-163r35,0","w":261},"\u0133":{"d":"38,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21xm40,0r0,-160r-26,0r0,-28r59,0r0,188r-33,0xm140,-239v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,12,-9,21,-21,21v-11,0,-20,-10,-20,-21xm88,44v42,-1,60,-8,60,-45r0,-159r-37,0r0,-28r71,0r0,186v-1,56,-33,76,-94,76r0,-30","w":216},"\u0134":{"d":"145,-258v-10,103,38,262,-77,262v-34,0,-58,-22,-59,-56r30,0v3,16,12,24,28,24v43,-2,43,-15,43,-67r0,-163r35,0xm139,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":171},"\u0135":{"d":"3,44v42,-1,60,-8,60,-45r0,-159r-37,0r0,-28r71,0r0,186v-1,56,-33,76,-94,76r0,-30xm94,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":132},"\u0136":{"d":"168,0r-72,-118r-34,48r0,70r-36,0r0,-258r36,0r0,141r95,-141r39,0r-77,112r88,146r-39,0xm92,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":207},"\u0137":{"d":"145,0r-59,-94r-29,30r0,64r-33,0r0,-265r33,0r0,164r72,-87r39,0r-60,71r74,117r-37,0xm83,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":181},"\u0138":{"d":"189,0r-44,0r-58,-85r-28,31r0,54r-34,0r0,-188r34,0r0,93r78,-93r42,0r-70,79","w":196},"\u013b":{"d":"26,0r0,-258r36,0r0,226r116,0r0,32r-152,0xm86,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":182},"\u013c":{"d":"60,-59v-1,20,13,33,31,33r0,30v-43,0,-65,-19,-65,-57r0,-212r34,0r0,206xm54,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":106},"\u0145":{"d":"193,4r-133,-189r0,185r-34,0r0,-258r14,0r130,179r0,-179r33,0r0,262r-10,0xm99,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":229},"\u0146":{"d":"140,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110xm82,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":196},"\u0149":{"d":"4,-201v24,-15,12,-29,4,-46v0,-12,6,-18,18,-18v13,0,19,6,19,21v0,22,-11,41,-33,54xm172,-110v11,-64,-62,-65,-83,-30r0,140r-33,0r0,-188r23,0r10,24v31,-50,116,-33,116,47r0,117r-33,0r0,-110","w":228},"\u014a":{"d":"175,-82v-5,-68,13,-148,-59,-148v-20,0,-37,10,-54,30r0,200r-36,0r0,-258r21,0r15,24v17,-19,38,-28,66,-28v54,0,82,35,82,103v-1,74,13,166,-61,163v-19,0,-33,-5,-44,-14r15,-26v32,22,58,2,55,-46","w":235},"\u014b":{"d":"140,-109v8,-63,-61,-67,-83,-31r0,140r-33,0r0,-188r23,0r10,24v31,-49,122,-33,116,47v-7,85,23,194,-78,191r0,-30v69,3,37,-94,45,-153","w":196},"\u014c":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm182,-304r0,25r-129,0r0,-25r129,0","w":242},"\u014d":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm161,-251r0,25r-129,0r0,-25r129,0","w":193},"\u014e":{"d":"118,4v-68,0,-104,-62,-104,-135v0,-69,38,-132,104,-131v75,0,111,54,111,131v0,78,-36,135,-111,135xm118,-230v-50,0,-66,45,-67,99v-1,53,20,104,67,104v53,0,75,-45,74,-104v0,-66,-25,-99,-74,-99xm117,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":242},"\u014f":{"d":"97,4v-56,0,-86,-42,-86,-99v0,-54,33,-97,86,-97v55,0,85,40,85,97v1,56,-31,99,-85,99xm97,-165v-34,0,-50,30,-50,70v0,47,17,71,50,71v35,0,50,-33,50,-71v0,-47,-17,-70,-50,-70xm96,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":193},"\u0156":{"d":"185,-186v0,31,-24,62,-50,68r75,118r-41,0r-68,-111v-8,0,-21,0,-38,-1r0,112r-35,0r0,-258v76,-7,157,-1,157,72xm148,-187v0,-40,-42,-44,-85,-39r0,84v43,5,85,1,85,-45xm92,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":209},"\u0157":{"d":"126,-156v-32,-24,-66,12,-66,48r0,108r-34,0r0,-188r34,0r0,30v17,-30,40,-40,80,-31xm39,11v34,-3,50,42,24,60v-9,6,-21,9,-36,9r-4,-17v15,0,31,-4,32,-18v0,-9,-5,-13,-16,-13r0,-21","w":139},"\u015c":{"d":"111,-139v78,32,52,143,-38,143v-23,0,-42,-5,-58,-16r13,-32v27,24,96,25,96,-23v0,-53,-79,-52,-99,-88v-27,-49,5,-107,62,-107v28,0,48,5,59,14r-10,31v-24,-19,-89,-24,-87,21v1,38,32,45,62,57xm113,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":173},"\u015d":{"d":"92,-105v65,21,48,109,-25,109v-20,0,-39,-5,-56,-15r12,-32v19,12,34,18,45,18v21,0,31,-9,31,-26v0,-42,-90,-37,-86,-92v4,-52,67,-61,113,-36r-10,31v-20,-19,-63,-25,-68,4v-4,22,26,33,44,39xm97,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":145},"\u0166":{"d":"206,-226r-86,0r0,89r56,0r0,26r-56,0r0,111r-35,0r0,-111r-55,0r0,-26r55,0r0,-89r-82,0r0,-32r203,0r0,32","w":209},"\u0167":{"d":"69,-91v0,35,-2,69,34,67v8,0,17,-3,26,-7r5,29v-46,17,-101,-2,-98,-53r0,-36r-27,0r0,-25r27,0r0,-46r-27,0r0,-26r27,0r0,-39r33,-13r0,52r55,0r0,26r-55,0r0,46r46,0r0,25r-46,0","w":142},"\u0168":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm93,-315v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":233},"\u0169":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm75,-262v24,-2,51,30,64,0r16,0v-9,50,-48,34,-77,23v-8,0,-15,4,-19,13r-16,0v3,-17,14,-35,32,-36","w":196},"\u016a":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm181,-304r0,25r-129,0r0,-25r129,0","w":233},"\u016b":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm163,-251r0,25r-129,0r0,-25r129,0","w":196},"\u016c":{"d":"116,4v-56,0,-90,-28,-90,-83r0,-179r36,0r0,177v-1,32,22,54,54,54v34,0,56,-21,56,-55r0,-176r35,0r0,180v1,53,-36,82,-91,82xm114,-306v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":233},"\u016d":{"d":"86,4v-88,4,-60,-111,-64,-192r33,0r0,120v-5,61,77,48,87,12r0,-132r33,0r0,188r-33,0r0,-26v-7,13,-35,30,-56,30xm98,-253v18,0,37,-13,36,-30r25,0v2,46,-68,78,-102,41v-10,-11,-15,-25,-15,-41r25,0v0,15,15,30,31,30","w":196},"\u0172":{"d":"116,-27v34,0,56,-21,56,-55r0,-176r35,0r0,180v-1,48,-25,71,-70,81v-16,4,-16,40,8,37v6,0,13,-2,19,-6r12,25v-41,21,-93,-7,-76,-55v-111,-5,-65,-157,-74,-262r36,0r0,177v-1,32,22,54,54,54","w":233},"\u0173":{"d":"175,0v-21,4,-25,41,2,40v6,0,13,-2,19,-6r12,25v-35,17,-79,2,-79,-37v0,-18,15,-26,13,-48v-6,13,-36,30,-56,30v-87,3,-60,-111,-64,-192r33,0r0,120v-5,62,76,49,87,12r0,-132r33,0r0,188","w":196},"\u0174":{"d":"224,4r-11,0r-61,-178r-57,178r-12,0r-81,-262r37,0r52,180r56,-180r12,0r56,180r53,-180r36,0xm182,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":306},"\u0175":{"d":"198,4r-9,0r-55,-129r-55,129r-9,0r-67,-193r35,0r41,124r50,-124r8,0r52,124r43,-124r33,0xm162,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":267},"\u0176":{"d":"120,-115r0,115r-35,0r0,-115r-83,-143r36,0r65,113r64,-113r36,0xm131,-279r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":205},"\u0177":{"d":"22,44v37,2,60,-26,45,-64r-65,-168r34,0r56,145r49,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30xm118,-226r-29,-33r-31,33r-30,0r52,-59r19,0r54,59r-35,0","w":177},"\u017f":{"d":"27,-186v-3,-60,38,-91,96,-75r-9,26v-38,-11,-54,11,-54,54r0,181r-33,0r0,-186","w":119},"\u01fa":{"d":"212,0r-39,0r-19,-54r-94,0r-20,54r-39,0r98,-229v-34,-7,-35,-57,-3,-66r18,-35r34,0r-24,35v32,9,30,60,-4,66xm110,-278v-10,0,-18,5,-18,15v0,11,6,16,18,16v12,0,18,-5,18,-16v0,-10,-6,-15,-18,-15xm145,-80r-37,-105r-38,105r75,0","w":212},"\u01fb":{"d":"175,3v-27,1,-38,-6,-45,-25v-28,43,-116,31,-116,-31v0,-48,62,-81,113,-63v6,-54,-64,-55,-89,-29r-14,-28v11,-9,38,-19,58,-19v83,0,81,66,78,146v0,17,5,27,15,33r0,16xm127,-92v-39,-13,-80,6,-80,40v0,42,63,35,80,5r0,-45xm53,-237v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm72,-237v0,10,9,18,18,18v11,0,18,-7,18,-18v0,-10,-8,-17,-18,-17v-9,0,-18,8,-18,17xm135,-339r-40,58r-25,0r30,-58r35,0","w":189},"\u01fc":{"d":"146,-54r-79,0r-25,54r-39,0r124,-258r172,0r0,32r-118,0r0,72r85,0r0,30r-85,0r0,92r116,0r0,32r-151,0r0,-54xm146,-226r-68,146r68,0r0,-146xm245,-337r-40,58r-25,0r30,-58r35,0","w":312},"\u01fd":{"d":"151,-161v48,-65,173,-19,147,70r-134,0v-7,61,70,87,106,47r14,27v-27,25,-90,30,-121,4v1,6,1,12,2,17r-29,0v-2,-8,-2,-9,-6,-26v-27,42,-116,31,-116,-27v0,-52,58,-82,113,-67v6,-54,-64,-55,-89,-29r-14,-28v30,-26,112,-26,127,12xm269,-115v3,-44,-62,-66,-90,-33v-10,11,-15,22,-15,33r105,0xm127,-92v-35,-14,-80,9,-80,40v0,42,63,35,80,5r0,-45xm204,-284r-40,58r-25,0r30,-58r35,0","w":314},"\u01fe":{"d":"226,-131v0,101,-80,167,-164,119r-12,16r-38,0r28,-37v-55,-72,-28,-229,75,-229v25,0,47,5,64,17r12,-17r35,0r-25,39v17,23,25,53,25,92xm115,-230v-72,-2,-78,108,-53,165r98,-151v-12,-10,-27,-14,-45,-14xm80,-40v57,38,109,-17,109,-91v0,-24,-3,-43,-10,-59xm154,-337r-40,58r-25,0r30,-58r35,0","w":236},"\u01ff":{"d":"160,-164v44,55,18,168,-64,168v-19,0,-36,-5,-49,-14r-10,14r-26,0r21,-29v-44,-55,-17,-167,64,-167v19,0,36,5,49,14r10,-14r26,0xm126,-153v-40,-28,-82,6,-82,58v0,17,3,32,8,43xm66,-35v39,31,82,-8,82,-60v0,-17,-3,-30,-8,-41xm136,-284r-40,58r-25,0r30,-58r35,0","w":196},"\u1e80":{"d":"224,4r-11,0r-61,-178r-57,178r-12,0r-81,-262r37,0r52,180r56,-180r12,0r56,180r53,-180r36,0xm147,-279r-39,-58r34,0r30,58r-25,0","w":306},"\u1e81":{"d":"198,4r-9,0r-55,-129r-55,129r-9,0r-67,-193r35,0r41,124r50,-124r8,0r52,124r43,-124r33,0xm128,-226r-39,-58r34,0r30,58r-25,0","w":267},"\u1e82":{"d":"224,4r-11,0r-61,-178r-57,178r-12,0r-81,-262r37,0r52,180r56,-180r12,0r56,180r53,-180r36,0xm199,-337r-40,58r-25,0r30,-58r35,0","w":306},"\u1e83":{"d":"198,4r-9,0r-55,-129r-55,129r-9,0r-67,-193r35,0r41,124r50,-124r8,0r52,124r43,-124r33,0xm177,-284r-40,58r-25,0r30,-58r35,0","w":267},"\u1e84":{"d":"224,4r-11,0r-61,-178r-57,178r-12,0r-81,-262r37,0r52,180r56,-180r12,0r56,180r53,-180r36,0xm92,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm175,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":306},"\u1e85":{"d":"198,4r-9,0r-55,-129r-55,129r-9,0r-67,-193r35,0r41,124r50,-124r8,0r52,124r43,-124r33,0xm71,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm154,-246v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":267},"\u1ef2":{"d":"120,-115r0,115r-35,0r0,-115r-83,-143r36,0r65,113r64,-113r36,0xm101,-279r-39,-58r34,0r30,58r-25,0","w":205},"\u1ef3":{"d":"22,44v37,2,60,-26,45,-64r-65,-168r34,0r56,145r49,-145r34,0r-79,220v-8,23,-42,43,-74,42r0,-30xm84,-226r-39,-58r34,0r30,58r-25,0","w":177},"\u2015":{"d":"16,-94r0,-16r230,0r0,16r-230,0","w":264},"\u2017":{"d":"189,45r-190,0r0,-23r190,0r0,23xm189,89r-190,0r0,-23r190,0r0,23"},"\u2032":{"d":"33,-186r-23,0r20,-72r33,0","w":57},"\u2033":{"d":"33,-186r-23,0r20,-72r33,0xm86,-186r-23,0r20,-72r32,0","w":121},"\u203c":{"d":"73,-67r-13,0v-15,-96,-13,-114,-13,-195r39,0v0,81,2,98,-13,195xm41,-23v0,-14,12,-26,27,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27xm159,-67r-13,0v-15,-96,-13,-114,-13,-195r39,0v0,81,2,98,-13,195xm127,-23v0,-14,12,-26,27,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27","w":219},"\u203e":{"d":"138,-259r0,22r-139,0r0,-22r139,0"},"\u207f":{"d":"99,-147v-5,-34,16,-96,-24,-95v-9,0,-17,4,-25,12r0,83r-24,0r0,-113r17,0r6,11v26,-24,74,-15,74,32r0,70r-24,0","w":140},"\u20a4":{"d":"39,-167v-3,-55,22,-94,72,-95v24,0,41,7,51,21r-16,24v-29,-32,-83,-15,-72,50r54,0r0,24r-54,0r0,28r54,0r0,23r-54,0r0,60v35,0,67,4,81,-20r25,20v-18,39,-97,32,-157,32r0,-24v24,-6,14,-41,16,-68r-16,0r0,-23r16,0r0,-28r-16,0r0,-24r16,0"},"\u20a7":{"d":"336,-164v-32,0,-29,36,-4,49v25,13,58,28,58,65v0,55,-73,67,-110,39v-33,33,-89,7,-89,-45r0,-106r-24,0v-8,48,-49,69,-108,63r0,99r-35,0r0,-258v79,-7,146,8,145,70r22,0r0,-39r33,-13r0,52r41,0r0,26r-41,0r0,95v-6,50,41,55,58,20v15,15,30,23,46,23v35,1,36,-41,7,-54v-25,-12,-59,-27,-57,-64v2,-52,59,-61,104,-37r-9,31v-13,-11,-25,-16,-37,-16xm134,-180v0,-37,-32,-52,-75,-47r0,96v42,8,75,-9,75,-49","w":400},"\u2105":{"d":"42,-201v0,37,37,52,63,29r11,19v-41,28,-99,5,-99,-48v0,-51,58,-79,98,-51r-12,17v-27,-19,-61,-2,-61,34xm234,-263r-172,270r-22,0r172,-270r22,0xm200,-116v36,0,55,24,55,60v0,35,-20,62,-55,61v-35,0,-55,-24,-55,-61v-1,-35,22,-60,55,-60xm230,-56v0,-27,-10,-40,-30,-40v-20,0,-30,13,-30,40v0,27,10,41,30,41v20,0,30,-14,30,-41","w":271},"\u2113":{"d":"79,-101v0,39,-1,75,35,75v8,0,17,-5,26,-15r19,27v-7,8,-33,18,-47,18v-52,0,-66,-29,-66,-86r-15,9r-10,-29v10,-6,18,-10,25,-15v-1,-71,0,-144,57,-145v30,0,49,19,48,51v-1,37,-44,87,-72,110xm103,-232v-25,0,-25,55,-24,88v26,-26,39,-47,39,-65v0,-15,-5,-23,-15,-23"},"\u2116":{"d":"261,-174v34,0,52,25,51,60v0,35,-18,60,-51,60v-33,1,-51,-26,-51,-60v0,-33,19,-60,51,-60xm304,0r-86,0r0,-23r86,0r0,23xm188,2r-12,0r-118,-180r0,178r-32,0r0,-260r12,0r118,180r0,-178r32,0r0,260xm286,-114v0,-25,-8,-38,-25,-38v-16,0,-25,13,-25,38v0,25,8,38,25,38v16,0,25,-13,25,-38","w":329},"\u212e":{"d":"11,-92v0,-85,101,-135,152,-71v16,20,24,43,24,69r-143,0r0,65v33,33,95,22,122,-3r8,10v-56,53,-163,20,-163,-70xm44,-156r0,50r111,0r0,-50v-26,-33,-84,-34,-111,0","w":197},"\u215b":{"d":"221,-156v46,-4,53,58,20,74v46,19,32,90,-20,86v-57,7,-59,-75,-19,-88v-38,-16,-23,-77,19,-72xm230,-262r-171,268r-22,0r171,-268r22,0xm74,-105r-23,0r0,-118r-33,20r0,-20v24,-12,40,-24,49,-37r7,0r0,155xm227,-91v15,-12,21,-45,-6,-45v-38,6,-10,39,6,45xm221,-16v38,-3,30,-47,-3,-59v-26,10,-32,59,3,59","w":293},"\u215c":{"d":"223,-156v46,0,53,58,20,74v44,19,32,86,-20,86v-59,0,-59,-73,-20,-88v-38,-16,-23,-72,20,-72xm238,-262r-171,268r-22,0r171,-268r22,0xm54,-262v46,0,62,61,22,75v48,14,35,84,-23,84v-15,0,-27,-4,-36,-12r11,-19v14,16,57,14,54,-15v-2,-18,-14,-29,-32,-29v1,-5,-2,-14,1,-17v17,0,26,-9,26,-25v0,-24,-35,-27,-46,-13r-10,-16v7,-9,18,-13,33,-13xm229,-91v15,-12,22,-45,-6,-45v-13,0,-19,6,-19,17v0,10,8,19,25,28xm223,-16v38,-3,30,-47,-3,-59v-26,10,-33,59,3,59","w":293},"\u215d":{"d":"223,-156v46,0,53,58,20,74v46,19,32,90,-20,86v-57,7,-59,-75,-19,-88v-39,-16,-24,-72,19,-72xm238,-262r-171,268r-22,0r171,-268r22,0xm45,-204v31,-18,70,7,66,44v7,54,-55,71,-90,45r8,-19v22,18,62,12,59,-23v4,-33,-39,-39,-57,-21r-7,-5r0,-76r78,0r0,20r-57,0r0,35xm229,-91v15,-12,21,-45,-6,-45v-36,5,-11,38,6,45xm223,-16v38,-3,30,-47,-3,-59v-26,10,-33,59,3,59","w":293},"\u215e":{"d":"223,-156v46,0,53,58,20,74v46,19,32,90,-20,86v-57,7,-59,-75,-19,-88v-39,-16,-24,-72,19,-72xm234,-262r-171,268r-22,0r171,-268r22,0xm129,-259v-17,55,-51,101,-64,154r-27,0v9,-28,30,-73,62,-134r-71,0r0,-20r100,0xm229,-91v15,-12,21,-45,-6,-45v-36,5,-11,38,6,45xm223,-16v38,-3,30,-47,-3,-59v-26,10,-33,59,3,59","w":293},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"104,-160r0,82r-81,0r0,-82r81,0","w":127},"\u25ab":{"d":"104,-160r0,82r-81,0r0,-82r81,0xm91,-146r-55,0r0,54r55,0r0,-54","w":127},"\u25cf":{"d":"109,-24v-41,0,-78,-36,-78,-77v0,-41,37,-78,78,-78v41,0,77,37,77,78v0,41,-36,77,-77,77","w":217},"\u25e6":{"d":"20,-119v0,-23,21,-44,44,-44v23,0,44,21,44,44v0,23,-21,44,-44,44v-23,0,-44,-21,-44,-44xm95,-119v0,-16,-14,-31,-31,-31v-17,0,-31,15,-31,31v-1,17,15,31,31,31v16,0,31,-14,31,-31","w":127},"\u201b":{"d":"92,-240v0,17,-33,37,-8,55r13,11r-12,16v-31,-20,-46,-45,-46,-76v0,-21,9,-31,27,-31v17,0,26,8,26,25","w":132}}});
